/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.set.immutable.AbstractImmutableSet;
import com.gs.collections.impl.set.immutable.ImmutableSetSerializationProxy;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableSingletonSet<T>
extends AbstractImmutableSet<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final T element1;

    ImmutableSingletonSet(T obj1) {
        this.element1 = obj1;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set set = (Set)other;
        return set.size() == this.size() && set.contains(this.element1);
    }

    @Override
    public int hashCode() {
        return this.nullSafeHashCode(this.element1);
    }

    @Override
    public ImmutableSet<T> newWith(T element) {
        if (!this.contains(element)) {
            return Sets.immutable.with(this.element1, element);
        }
        return this;
    }

    @Override
    public ImmutableSet<T> newWithout(T element) {
        if (this.contains(element)) {
            return Sets.immutable.empty();
        }
        return this;
    }

    @Override
    public boolean contains(Object obj) {
        return Comparators.nullSafeEquals(obj, this.element1);
    }

    @Override
    public Iterator<T> iterator() {
        return new SingletonSetIterator();
    }

    @Override
    public T getFirst() {
        return this.element1;
    }

    @Override
    public T getLast() {
        return this.element1;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        procedure.value(this.element1);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        objectIntProcedure.value(this.element1, 0);
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        procedure.value(this.element1, parameter);
    }

    private Object writeReplace() {
        return new ImmutableSetSerializationProxy(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SingletonSetIterator
    extends AbstractImmutableSet.ImmutableSetIterator {
        private SingletonSetIterator() {
        }

        @Override
        protected T getElement(int i) {
            if (i == 0) {
                return ImmutableSingletonSet.this.element1;
            }
            throw new NoSuchElementException("i=" + i);
        }
    }
}

