/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import java.io.Serializable;
import net.jcip.annotations.GuardedBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedBooleanIterable
implements BooleanIterable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    @GuardedBy(value="this.lock")
    private final BooleanIterable iterable;

    protected SynchronizedBooleanIterable(BooleanIterable iterable) {
        this(iterable, null);
    }

    protected SynchronizedBooleanIterable(BooleanIterable iterable, Object newLock) {
        if (iterable == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedBooleanIterable on a null collection");
        }
        this.iterable = iterable;
        this.lock = newLock == null ? this : newLock;
    }

    public static SynchronizedBooleanIterable of(BooleanIterable iterable) {
        return new SynchronizedBooleanIterable(iterable);
    }

    public static SynchronizedBooleanIterable of(BooleanIterable iterable, Object lock) {
        return new SynchronizedBooleanIterable(iterable, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(boolean ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(BooleanIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.containsAll(source);
        }
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void each(BooleanProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanIterable select(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanIterable reject(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> RichIterable<V> collect(BooleanToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyBooleanIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable, start, separator, end);
        }
    }

    @Override
    public BooleanIterator booleanIterator() {
        return this.iterable.booleanIterator();
    }
}

