/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.partition.stack;

import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.partition.stack.PartitionImmutableStack;
import com.gs.collections.api.partition.stack.PartitionMutableStack;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.partition.stack.PartitionImmutableStackImpl;
import com.gs.collections.impl.stack.mutable.ArrayStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionArrayStack<T>
implements PartitionMutableStack<T> {
    private final MutableList<T> selected = FastList.newList();
    private final MutableList<T> rejected = FastList.newList();

    @Override
    public MutableStack<T> getSelected() {
        return ArrayStack.newStackFromTopToBottom(this.selected);
    }

    @Override
    public MutableStack<T> getRejected() {
        return ArrayStack.newStackFromTopToBottom(this.rejected);
    }

    @Override
    public PartitionImmutableStack<T> toImmutable() {
        return new PartitionImmutableStackImpl(this);
    }

    @Override
    public void add(T t) {
        throw new UnsupportedOperationException("add is no longer supported for PartitionArrayStack");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PartitionPredicate2Procedure<T, P>
    implements Procedure<T> {
        private static final long serialVersionUID = 1L;
        private final Predicate2<? super T, ? super P> predicate;
        private final P parameter;
        private final PartitionArrayStack<T> partitionMutableStack;

        public PartitionPredicate2Procedure(Predicate2<? super T, ? super P> predicate, P parameter, PartitionArrayStack<T> partitionMutableStack) {
            this.predicate = predicate;
            this.parameter = parameter;
            this.partitionMutableStack = partitionMutableStack;
        }

        @Override
        public void value(T each) {
            MutableList bucket = this.predicate.accept(each, this.parameter) ? ((PartitionArrayStack)this.partitionMutableStack).selected : ((PartitionArrayStack)this.partitionMutableStack).rejected;
            bucket.add(each);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PartitionProcedure<T>
    implements Procedure<T> {
        private static final long serialVersionUID = 1L;
        private final Predicate<? super T> predicate;
        private final PartitionArrayStack<T> partitionMutableStack;

        public PartitionProcedure(Predicate<? super T> predicate, PartitionArrayStack<T> partitionMutableStack) {
            this.predicate = predicate;
            this.partitionMutableStack = partitionMutableStack;
        }

        @Override
        public void value(T each) {
            MutableList bucket = this.predicate.accept(each) ? ((PartitionArrayStack)this.partitionMutableStack).selected : ((PartitionArrayStack)this.partitionMutableStack).rejected;
            bucket.add(each);
        }
    }
}

