/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.parallel;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.parallel.ParallelIterate;
import com.gs.collections.impl.parallel.PassThruCombiner;
import com.gs.collections.impl.parallel.PassThruProcedureFactory;
import com.gs.collections.impl.utility.MapIterate;
import java.util.Map;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParallelMapIterate {
    private ParallelMapIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <K, V> void forEachKeyValue(Map<K, V> map, Procedure2<? super K, ? super V> procedure2) {
        ParallelMapIterate.forEachKeyValue(map, procedure2, 2, map.size());
    }

    public static <K, V> void forEachKeyValue(Map<K, V> map, Procedure2<? super K, ? super V> procedure, Executor executor) {
        ParallelMapIterate.forEachKeyValue(map, procedure, 2, map.size(), executor);
    }

    public static <K, V> void forEachKeyValue(Map<K, V> map, Procedure2<? super K, ? super V> procedure, int minForkSize, int taskCount) {
        if (map.size() > minForkSize) {
            PairProcedure pairProcedure = new PairProcedure(procedure);
            ParallelIterate.forEach(MapIterate.toListOfPairs(map), new PassThruProcedureFactory(pairProcedure), new PassThruCombiner(), minForkSize, taskCount);
        } else {
            MapIterate.forEachKeyValue(map, procedure);
        }
    }

    public static <K, V> void forEachKeyValue(Map<K, V> map, Procedure2<? super K, ? super V> procedure, int minForkSize, int taskCount, Executor executor) {
        if (map.size() > minForkSize) {
            PairProcedure pairProcedure = new PairProcedure(procedure);
            ParallelIterate.forEachInListOnExecutor(MapIterate.toListOfPairs(map), new PassThruProcedureFactory(pairProcedure), new PassThruCombiner(), minForkSize, taskCount, executor);
        } else {
            MapIterate.forEachKeyValue(map, procedure);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PairProcedure<T1, T2>
    implements Procedure<Pair<T1, T2>> {
        private static final long serialVersionUID = 1L;
        private final Procedure2<? super T1, ? super T2> procedure;

        private PairProcedure(Procedure2<? super T1, ? super T2> procedure) {
            this.procedure = procedure;
        }

        @Override
        public void value(Pair<T1, T2> pair) {
            this.procedure.value(pair.getOne(), pair.getTwo());
        }
    }
}

