/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.parallel;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.impl.parallel.ArrayProcedureFJTask;
import com.gs.collections.impl.parallel.Combiner;
import com.gs.collections.impl.parallel.ProcedureFactory;
import com.gs.collections.impl.utility.ArrayIterate;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayProcedureFJTaskRunner<T, BT extends Procedure<? super T>> {
    private final Function<ArrayProcedureFJTask<T, BT>, BT> procedureFunction = new ProcedureExtractor();
    private ArrayProcedureFJTask<T, BT>[] procedures;
    private Throwable error;
    private final CountDownLatch latch;
    private final Combiner<BT> combiner;
    private final BlockingQueue<BT> outputQueue;
    private final int taskCount;

    public ArrayProcedureFJTaskRunner(Combiner<BT> newCombiner, int newTaskCount) {
        this.combiner = newCombiner;
        this.taskCount = newTaskCount;
        if (this.combiner.useCombineOne()) {
            this.outputQueue = new ArrayBlockingQueue<BT>(newTaskCount);
            this.latch = null;
        } else {
            this.latch = new CountDownLatch(newTaskCount);
            this.outputQueue = null;
        }
    }

    private void createAndExecuteTasks(Executor executor, ProcedureFactory<BT> procedureFactory, T[] array) {
        this.procedures = new ArrayProcedureFJTask[this.taskCount];
        int sectionSize = array.length / this.taskCount;
        int size = this.taskCount;
        for (int index = 0; index < size; ++index) {
            ArrayProcedureFJTask<T, BT> procedureFJTask = new ArrayProcedureFJTask<T, BT>(this, procedureFactory, array, index, sectionSize, index == this.taskCount - 1);
            this.procedures[index] = procedureFJTask;
            executor.execute(procedureFJTask);
        }
    }

    public void taskCompleted(ArrayProcedureFJTask<T, BT> task) {
        if (this.combiner.useCombineOne()) {
            this.outputQueue.add(task.getProcedure());
        } else {
            this.latch.countDown();
        }
    }

    private void join() {
        try {
            if (this.combiner.useCombineOne()) {
                for (int remaingTaskCount = this.taskCount; remaingTaskCount > 0; --remaingTaskCount) {
                    this.combiner.combineOne(this.outputQueue.take());
                }
            } else {
                this.latch.await();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Combine failed", e);
        }
    }

    public void executeAndCombine(Executor executor, ProcedureFactory<BT> procedureFactory, T[] array) {
        this.createAndExecuteTasks(executor, procedureFactory, array);
        this.join();
        if (this.error != null) {
            throw new RuntimeException("One or more parallel tasks failed", this.error);
        }
        this.combineTasks();
    }

    public void setFailed(Throwable newError) {
        this.error = newError;
    }

    private void combineTasks() {
        if (!this.combiner.useCombineOne()) {
            this.combiner.combineAll(ArrayIterate.collect(this.procedures, this.procedureFunction));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProcedureExtractor
    implements Function<ArrayProcedureFJTask<T, BT>, BT> {
        private static final long serialVersionUID = 1L;

        private ProcedureExtractor() {
        }

        @Override
        public BT valueOf(ArrayProcedureFJTask<T, BT> object) {
            return object.getProcedure();
        }
    }
}

