/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap.set;

import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.set.MutableSetMultimap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.set.AbstractMutableSetMultimap;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.utility.Iterate;
import java.io.Externalizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnifiedSetMultimap<K, V>
extends AbstractMutableSetMultimap<K, V>
implements Externalizable {
    private static final long serialVersionUID = 1L;

    public UnifiedSetMultimap() {
    }

    public UnifiedSetMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(Math.max(multimap.sizeDistinct() * 2, 16));
        this.putAll(multimap);
    }

    public UnifiedSetMultimap(Pair<K, V> ... pairs) {
        super(pairs);
    }

    public UnifiedSetMultimap(Iterable<Pair<K, V>> inputIterable) {
        super(inputIterable);
    }

    public static <K, V> UnifiedSetMultimap<K, V> newMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new UnifiedSetMultimap<K, V>(multimap);
    }

    public static <K, V> UnifiedSetMultimap<K, V> newMultimap() {
        return new UnifiedSetMultimap<K, V>();
    }

    public static <K, V> UnifiedSetMultimap<K, V> newMultimap(Pair<K, V> ... pairs) {
        return new UnifiedSetMultimap<K, V>(pairs);
    }

    public static <K, V> UnifiedSetMultimap<K, V> newMultimap(Iterable<Pair<K, V>> inputIterable) {
        return new UnifiedSetMultimap<K, V>(inputIterable);
    }

    @Override
    protected MutableMap<K, MutableSet<V>> createMap() {
        return UnifiedMap.newMap();
    }

    @Override
    protected MutableMap<K, MutableSet<V>> createMapWithKeyCount(int keyCount) {
        return UnifiedMap.newMap(keyCount);
    }

    @Override
    protected MutableSet<V> createCollection() {
        return new UnifiedSet();
    }

    @Override
    public UnifiedSetMultimap<K, V> newEmpty() {
        return new UnifiedSetMultimap<K, V>();
    }

    @Override
    public MutableSetMultimap<V, K> flip() {
        return Iterate.flip(this);
    }

    @Override
    public UnifiedSetMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return (UnifiedSetMultimap)this.selectKeysValues(predicate, this.newEmpty());
    }

    @Override
    public UnifiedSetMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return (UnifiedSetMultimap)this.rejectKeysValues(predicate, this.newEmpty());
    }

    @Override
    public UnifiedSetMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return (UnifiedSetMultimap)this.selectKeysMultiValues(predicate, this.newEmpty());
    }

    @Override
    public UnifiedSetMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return (UnifiedSetMultimap)this.rejectKeysMultiValues(predicate, this.newEmpty());
    }
}

