/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap.bag;

import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.map.ImmutableMap;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.multimap.bag.ImmutableBagMultimap;
import com.gs.collections.api.multimap.bag.MutableBagMultimap;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.block.procedure.checked.CheckedObjectIntProcedure;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure2;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.Maps;
import com.gs.collections.impl.multimap.AbstractImmutableMultimap;
import com.gs.collections.impl.multimap.bag.HashBagMultimap;
import com.gs.collections.impl.utility.Iterate;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableBagMultimapImpl<K, V>
extends AbstractImmutableMultimap<K, V, ImmutableBag<V>>
implements ImmutableBagMultimap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;

    public ImmutableBagMultimapImpl(MutableMap<K, ImmutableBag<V>> map) {
        super(map);
    }

    public ImmutableBagMultimapImpl(ImmutableMap<K, ImmutableBag<V>> map) {
        super(map);
    }

    @Override
    protected ImmutableBag<V> createCollection() {
        return Bags.immutable.empty();
    }

    @Override
    public ImmutableBagMultimap<K, V> newEmpty() {
        return new ImmutableBagMultimapImpl(Maps.immutable.of());
    }

    @Override
    public MutableBagMultimap<K, V> toMutable() {
        return new HashBagMultimap(this);
    }

    @Override
    public ImmutableBagMultimap<K, V> toImmutable() {
        return this;
    }

    private Object writeReplace() {
        return new ImmutableBagMultimapSerializationProxy(this.map);
    }

    @Override
    public ImmutableBagMultimap<K, V> newWith(K key, V value) {
        return (ImmutableBagMultimap)super.newWith(key, value);
    }

    @Override
    public ImmutableBagMultimap<K, V> newWithout(Object key, Object value) {
        return (ImmutableBagMultimap)super.newWithout(key, value);
    }

    @Override
    public ImmutableBagMultimap<K, V> newWithAll(K key, Iterable<? extends V> values) {
        return (ImmutableBagMultimap)super.newWithAll(key, values);
    }

    @Override
    public ImmutableBagMultimap<K, V> newWithoutAll(Object key) {
        return (ImmutableBagMultimap)super.newWithoutAll(key);
    }

    @Override
    public ImmutableBagMultimap<V, K> flip() {
        return Iterate.flip(this).toImmutable();
    }

    @Override
    public ImmutableBagMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return this.selectKeysValues(predicate, HashBagMultimap.newMultimap()).toImmutable();
    }

    @Override
    public ImmutableBagMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return this.rejectKeysValues(predicate, HashBagMultimap.newMultimap()).toImmutable();
    }

    @Override
    public ImmutableBagMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return this.selectKeysMultiValues(predicate, HashBagMultimap.newMultimap()).toImmutable();
    }

    @Override
    public ImmutableBagMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return this.rejectKeysMultiValues(predicate, HashBagMultimap.newMultimap()).toImmutable();
    }

    @Override
    public <K2, V2> ImmutableBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return this.collectKeysValues(function, HashBagMultimap.newMultimap()).toImmutable();
    }

    @Override
    public <V2> ImmutableBagMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        return this.collectValues(function, HashBagMultimap.newMultimap()).toImmutable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmutableBagMultimapSerializationProxy<K, V>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ImmutableMap<K, ImmutableBag<V>> map;
        private MutableMultimap<K, V> multimap;

        public ImmutableBagMultimapSerializationProxy() {
        }

        private ImmutableBagMultimapSerializationProxy(ImmutableMap<K, ImmutableBag<V>> map) {
            this.map = map;
        }

        protected Object readResolve() {
            return this.multimap.toImmutable();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.multimap = new HashBagMultimap();
            int keyCount = in.readInt();
            for (int i = 0; i < keyCount; ++i) {
                Object key = in.readObject();
                int valuesSize = in.readInt();
                MutableBag<Object> bag = Bags.mutable.empty();
                for (int j = 0; j < valuesSize; ++j) {
                    Object value = in.readObject();
                    int count = in.readInt();
                    bag.addOccurrences(value, count);
                }
                this.multimap.putAll(key, bag);
            }
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            int keysCount = this.map.size();
            out.writeInt(keysCount);
            this.map.forEachKeyValue(new CheckedProcedure2<K, ImmutableBag<V>>(){

                @Override
                public void safeValue(K key, ImmutableBag<V> bag) throws IOException {
                    out.writeObject(key);
                    out.writeInt(bag.sizeDistinct());
                    bag.forEachWithOccurrences(new CheckedObjectIntProcedure<V>(){

                        @Override
                        public void safeValue(V value, int count) throws IOException {
                            out.writeObject(value);
                            out.writeInt(count);
                        }
                    });
                }
            });
        }
    }
}

