/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap.bag;

import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.bag.MutableBagMultimap;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.bag.AbstractMutableBagMultimap;
import com.gs.collections.impl.utility.Iterate;
import java.io.Externalizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashBagMultimap<K, V>
extends AbstractMutableBagMultimap<K, V>
implements Externalizable {
    private static final long serialVersionUID = 1L;

    public HashBagMultimap() {
    }

    public HashBagMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(Math.max(multimap.keysView().size() * 2, 16));
        this.putAll(multimap);
    }

    public HashBagMultimap(Pair<K, V> ... pairs) {
        super(pairs);
    }

    public HashBagMultimap(Iterable<Pair<K, V>> inputIterable) {
        super(inputIterable);
    }

    public static <K, V> HashBagMultimap<K, V> newMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new HashBagMultimap<K, V>(multimap);
    }

    public static <K, V> HashBagMultimap<K, V> newMultimap() {
        return new HashBagMultimap<K, V>();
    }

    public static <K, V> HashBagMultimap<K, V> newMultimap(Pair<K, V> ... pairs) {
        return new HashBagMultimap<K, V>(pairs);
    }

    public static <K, V> HashBagMultimap<K, V> newMultimap(Iterable<Pair<K, V>> inputIterable) {
        return new HashBagMultimap<K, V>(inputIterable);
    }

    @Override
    protected MutableMap<K, MutableBag<V>> createMap() {
        return UnifiedMap.newMap();
    }

    @Override
    protected MutableMap<K, MutableBag<V>> createMapWithKeyCount(int keyCount) {
        return UnifiedMap.newMap(keyCount);
    }

    @Override
    protected MutableBag<V> createCollection() {
        return HashBag.newBag();
    }

    @Override
    public HashBagMultimap<K, V> newEmpty() {
        return new HashBagMultimap<K, V>();
    }

    @Override
    public MutableBagMultimap<V, K> flip() {
        return Iterate.flip(this);
    }

    @Override
    public <V2> HashBagMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        return this.collectValues(function, HashBagMultimap.<K, V>newMultimap());
    }

    @Override
    public HashBagMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return (HashBagMultimap)this.selectKeysValues(predicate, this.newEmpty());
    }

    @Override
    public HashBagMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return (HashBagMultimap)this.rejectKeysValues(predicate, this.newEmpty());
    }

    @Override
    public HashBagMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return (HashBagMultimap)this.selectKeysMultiValues(predicate, this.newEmpty());
    }

    @Override
    public HashBagMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return (HashBagMultimap)this.rejectKeysMultiValues(predicate, this.newEmpty());
    }
}

