/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap;

import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.Bag;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.UnmodifiableRichIterable;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.tuple.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultimap<K, V, C extends RichIterable<V>>
implements Multimap<K, V> {
    private static final Function<AbstractMultimap<?, ?, ?>, ?> CREATE_COLLECTION_BLOCK = new Function<AbstractMultimap<?, ?, ?>, RichIterable<?>>(){

        @Override
        public RichIterable<?> valueOf(AbstractMultimap<?, ?, ?> multimap) {
            return multimap.createCollection();
        }
    };

    protected abstract MapIterable<K, C> getMap();

    protected abstract C createCollection();

    protected Function<AbstractMultimap<K, V, C>, C> createCollectionBlock() {
        return CREATE_COLLECTION_BLOCK;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public boolean containsValue(final Object value) {
        return this.getMap().anySatisfy(new Predicate<C>(){

            @Override
            public boolean accept(C collection) {
                return collection.contains(value);
            }
        });
    }

    @Override
    public boolean containsKeyAndValue(Object key, Object value) {
        RichIterable collection = (RichIterable)this.getMap().get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public RichIterable<K> keysView() {
        return this.getMap().keysView();
    }

    @Override
    public RichIterable<RichIterable<V>> multiValuesView() {
        return this.getMap().valuesView().collect(new Function<C, RichIterable<V>>(){

            @Override
            public RichIterable<V> valueOf(C multiValue) {
                return UnmodifiableRichIterable.of(multiValue);
            }
        });
    }

    @Override
    public Bag<K> keyBag() {
        final MutableBag bag = Bags.mutable.empty();
        this.getMap().forEachKeyValue(new Procedure2<K, C>(){

            @Override
            public void value(K key, C value) {
                bag.addOccurrences(key, value.size());
            }
        });
        return bag;
    }

    @Override
    public RichIterable<V> valuesView() {
        return this.getMap().valuesView().flatCollect(Functions.identity());
    }

    @Override
    public RichIterable<Pair<K, RichIterable<V>>> keyMultiValuePairsView() {
        return this.getMap().keyValuesView().collect(new Function<Pair<K, C>, Pair<K, RichIterable<V>>>(){

            @Override
            public Pair<K, RichIterable<V>> valueOf(Pair<K, C> pair) {
                return Tuples.pair(pair.getOne(), UnmodifiableRichIterable.of((RichIterable)pair.getTwo()));
            }
        });
    }

    @Override
    public RichIterable<Pair<K, V>> keyValuePairsView() {
        return this.keyMultiValuePairsView().flatCollect(new Function<Pair<K, RichIterable<V>>, Iterable<Pair<K, V>>>(){

            @Override
            public Iterable<Pair<K, V>> valueOf(Pair<K, RichIterable<V>> pair) {
                return pair.getTwo().collect(new KeyValuePairFunction(pair.getOne()));
            }
        });
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multimap) {
            Multimap that = (Multimap)object;
            return this.getMap().equals(that.toMap());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getMap().hashCode();
    }

    public String toString() {
        return this.getMap().toString();
    }

    @Override
    public boolean notEmpty() {
        return !this.isEmpty();
    }

    @Override
    public void forEachValue(final Procedure<? super V> procedure) {
        this.getMap().forEachValue(new Procedure<C>(){

            @Override
            public void value(C collection) {
                collection.forEach(procedure);
            }
        });
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        this.getMap().forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(final Procedure2<K, V> procedure) {
        final Procedure2 innerProcedure = new Procedure2<V, K>(){

            @Override
            public void value(V value, K key) {
                procedure.value(key, value);
            }
        };
        this.getMap().forEachKeyValue(new Procedure2<K, C>(){

            @Override
            public void value(K key, C collection) {
                collection.forEachWith(innerProcedure, key);
            }
        });
    }

    @Override
    public void forEachKeyMultiValues(Procedure2<K, ? super Iterable<V>> procedure) {
        this.getMap().forEachKeyValue(procedure);
    }

    @Override
    public <R extends MutableMultimap<K, V>> R selectKeysValues(final Predicate2<? super K, ? super V> predicate, final R target) {
        this.getMap().forEachKeyValue(new Procedure2<K, C>(){

            @Override
            public void value(final K key, C collection) {
                RichIterable selectedValues = collection.select(new Predicate<V>(){

                    @Override
                    public boolean accept(V value) {
                        return predicate.accept(key, value);
                    }
                });
                target.putAll(key, selectedValues);
            }
        });
        return target;
    }

    @Override
    public <R extends MutableMultimap<K, V>> R rejectKeysValues(final Predicate2<? super K, ? super V> predicate, final R target) {
        this.getMap().forEachKeyValue(new Procedure2<K, C>(){

            @Override
            public void value(final K key, C collection) {
                RichIterable selectedValues = collection.reject(new Predicate<V>(){

                    @Override
                    public boolean accept(V value) {
                        return predicate.accept(key, value);
                    }
                });
                target.putAll(key, selectedValues);
            }
        });
        return target;
    }

    @Override
    public <R extends MutableMultimap<K, V>> R selectKeysMultiValues(final Predicate2<? super K, ? super Iterable<V>> predicate, final R target) {
        this.forEachKeyMultiValues(new Procedure2<K, Iterable<V>>(){

            @Override
            public void value(K key, Iterable<V> collection) {
                if (predicate.accept(key, collection)) {
                    target.putAll(key, collection);
                }
            }
        });
        return target;
    }

    @Override
    public <R extends MutableMultimap<K, V>> R rejectKeysMultiValues(final Predicate2<? super K, ? super Iterable<V>> predicate, final R target) {
        this.forEachKeyMultiValues(new Procedure2<K, Iterable<V>>(){

            @Override
            public void value(K key, Iterable<V> collection) {
                if (!predicate.accept(key, collection)) {
                    target.putAll(key, collection);
                }
            }
        });
        return target;
    }

    @Override
    public <K2, V2, R extends MutableMultimap<K2, V2>> R collectKeysValues(final Function2<? super K, ? super V, Pair<K2, V2>> function, final R target) {
        this.getMap().forEachKeyValue(new Procedure2<K, C>(){

            @Override
            public void value(final K key, C collection) {
                collection.forEach(new Procedure<V>(){

                    @Override
                    public void value(V value) {
                        Pair pair = (Pair)function.value(key, value);
                        target.add(pair);
                    }
                });
            }
        });
        return target;
    }

    @Override
    public <V2, R extends MutableMultimap<K, V2>> R collectValues(final Function<? super V, ? extends V2> function, final R target) {
        this.getMap().forEachKeyValue(new Procedure2<K, C>(){

            @Override
            public void value(K key, C collection) {
                target.putAll(key, collection.collect(function));
            }
        });
        return target;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyValuePairFunction<V, K>
    implements Function<V, Pair<K, V>> {
        private static final long serialVersionUID = 1L;
        private final K key;

        private KeyValuePairFunction(K key) {
            this.key = key;
        }

        @Override
        public Pair<K, V> valueOf(V value) {
            return Tuples.pair(this.key, value);
        }
    }
}

