/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.ObjectShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.MutableShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.ImmutableObjectShortMap;
import com.gs.collections.api.map.primitive.MutableObjectShortMap;
import com.gs.collections.api.map.primitive.ObjectShortMap;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.tuple.primitive.ObjectShortPair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import com.gs.collections.impl.factory.primitive.ObjectShortMaps;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedObjectShortMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableObjectShortMap<K>
implements MutableObjectShortMap<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectShortMap<K> map;

    UnmodifiableObjectShortMap(MutableObjectShortMap<K> map) {
        this.map = map;
    }

    private boolean isAbsent(short result, K key) {
        return result == 0 && !this.containsKey(key);
    }

    private short getIfAbsentThrow(K key) {
        short result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public void put(K key, short value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    @Override
    public void putAll(ObjectShortMap<? extends K> map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public void removeKey(K key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    @Override
    public void remove(Object key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public short removeKeyIfAbsent(K key, short value) {
        throw new UnsupportedOperationException("Cannot call removeKeyIfAbsent() on " + this.getClass().getSimpleName());
    }

    @Override
    public short getIfAbsentPut(K key, short value) {
        return this.getIfAbsentThrow(key);
    }

    @Override
    public short getIfAbsentPut(K key, ShortFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    @Override
    public short getIfAbsentPutWithKey(K key, ShortFunction<? super K> function) {
        return this.getIfAbsentThrow(key);
    }

    @Override
    public <P> short getIfAbsentPutWith(K key, ShortFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    @Override
    public short updateValue(K key, short initialValueIfAbsent, ShortToShortFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public short addToValue(K key, short toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public short get(Object key) {
        return this.map.get(key);
    }

    @Override
    public short getOrThrow(Object key) {
        return this.map.getOrThrow(key);
    }

    @Override
    public short getIfAbsent(Object key, short ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(short value) {
        return this.map.containsValue(value);
    }

    @Override
    public void forEachValue(ShortProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        this.map.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ObjectShortProcedure<? super K> procedure) {
        this.map.forEachKeyValue(procedure);
    }

    @Override
    public MutableObjectShortMap<K> select(ObjectShortPredicate<? super K> predicate) {
        return this.map.select(predicate);
    }

    @Override
    public MutableObjectShortMap<K> reject(ObjectShortPredicate<? super K> predicate) {
        return this.map.reject(predicate);
    }

    @Override
    public MutableShortIterator shortIterator() {
        return new UnmodifiableShortIterator(this.map.shortIterator());
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ShortProcedure procedure) {
        this.map.forEach(procedure);
    }

    @Override
    public int count(ShortPredicate predicate) {
        return this.map.count(predicate);
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    @Override
    public MutableShortCollection select(ShortPredicate predicate) {
        return this.map.select(predicate);
    }

    @Override
    public MutableShortCollection reject(ShortPredicate predicate) {
        return this.map.reject(predicate);
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V1> MutableCollection<V1> collect(ShortToObjectFunction<? extends V1> function) {
        return this.map.collect(function);
    }

    @Override
    public long sum() {
        return this.map.sum();
    }

    @Override
    public short max() {
        return this.map.max();
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    @Override
    public short min() {
        return this.map.min();
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.map.average();
    }

    @Override
    public double median() {
        return this.map.median();
    }

    @Override
    public short[] toSortedArray() {
        return this.map.toSortedArray();
    }

    @Override
    public MutableShortList toSortedList() {
        return this.map.toSortedList();
    }

    @Override
    public short[] toArray() {
        return this.map.toArray();
    }

    @Override
    public boolean contains(short value) {
        return this.map.contains(value);
    }

    @Override
    public boolean containsAll(short ... source) {
        return this.map.containsAll(source);
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        return this.map.containsAll(source);
    }

    @Override
    public MutableShortList toList() {
        return this.map.toList();
    }

    @Override
    public MutableShortSet toSet() {
        return this.map.toSet();
    }

    @Override
    public MutableShortBag toBag() {
        return this.map.toBag();
    }

    @Override
    public LazyShortIterable asLazy() {
        return this.map.asLazy();
    }

    @Override
    public MutableObjectShortMap<K> withKeyValue(K key, short value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableObjectShortMap<K> withoutKey(K key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableObjectShortMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableObjectShortMap<K> asUnmodifiable() {
        return this;
    }

    @Override
    public MutableObjectShortMap<K> asSynchronized() {
        return new SynchronizedObjectShortMap(this);
    }

    @Override
    public ImmutableObjectShortMap<K> toImmutable() {
        return ObjectShortMaps.immutable.withAll(this);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of(this.map.values());
    }

    @Override
    public LazyIterable<K> keysView() {
        return this.map.keysView();
    }

    @Override
    public RichIterable<ObjectShortPair<K>> keyValuesView() {
        return this.map.keyValuesView();
    }

    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public String makeString() {
        return this.map.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return this.map.injectInto(injectedValue, function);
    }
}

