/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectFloatPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectFloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.MutableFloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.ImmutableObjectFloatMap;
import com.gs.collections.api.map.primitive.MutableObjectFloatMap;
import com.gs.collections.api.map.primitive.ObjectFloatMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.ObjectFloatPair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.factory.primitive.ObjectFloatMaps;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedObjectFloatMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableObjectFloatMap<K>
implements MutableObjectFloatMap<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectFloatMap<K> map;

    UnmodifiableObjectFloatMap(MutableObjectFloatMap<K> map) {
        this.map = map;
    }

    private boolean isAbsent(float result, K key) {
        return result == 0.0f && !this.containsKey(key);
    }

    private float getIfAbsentThrow(K key) {
        float result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public void put(K key, float value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    @Override
    public void putAll(ObjectFloatMap<? extends K> map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public void removeKey(K key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    @Override
    public void remove(Object key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public float removeKeyIfAbsent(K key, float value) {
        throw new UnsupportedOperationException("Cannot call removeKeyIfAbsent() on " + this.getClass().getSimpleName());
    }

    @Override
    public float getIfAbsentPut(K key, float value) {
        return this.getIfAbsentThrow(key);
    }

    @Override
    public float getIfAbsentPut(K key, FloatFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    @Override
    public float getIfAbsentPutWithKey(K key, FloatFunction<? super K> function) {
        return this.getIfAbsentThrow(key);
    }

    @Override
    public <P> float getIfAbsentPutWith(K key, FloatFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    @Override
    public float updateValue(K key, float initialValueIfAbsent, FloatToFloatFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public float addToValue(K key, float toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public float get(Object key) {
        return this.map.get(key);
    }

    @Override
    public float getOrThrow(Object key) {
        return this.map.getOrThrow(key);
    }

    @Override
    public float getIfAbsent(Object key, float ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(float value) {
        return this.map.containsValue(value);
    }

    @Override
    public void forEachValue(FloatProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        this.map.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ObjectFloatProcedure<? super K> procedure) {
        this.map.forEachKeyValue(procedure);
    }

    @Override
    public MutableObjectFloatMap<K> select(ObjectFloatPredicate<? super K> predicate) {
        return this.map.select(predicate);
    }

    @Override
    public MutableObjectFloatMap<K> reject(ObjectFloatPredicate<? super K> predicate) {
        return this.map.reject(predicate);
    }

    @Override
    public MutableFloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(this.map.floatIterator());
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(FloatProcedure procedure) {
        this.map.forEach(procedure);
    }

    @Override
    public int count(FloatPredicate predicate) {
        return this.map.count(predicate);
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    @Override
    public MutableFloatCollection select(FloatPredicate predicate) {
        return this.map.select(predicate);
    }

    @Override
    public MutableFloatCollection reject(FloatPredicate predicate) {
        return this.map.reject(predicate);
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V1> MutableCollection<V1> collect(FloatToObjectFunction<? extends V1> function) {
        return this.map.collect(function);
    }

    @Override
    public double sum() {
        return this.map.sum();
    }

    @Override
    public float max() {
        return this.map.max();
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    @Override
    public float min() {
        return this.map.min();
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.map.average();
    }

    @Override
    public double median() {
        return this.map.median();
    }

    @Override
    public float[] toSortedArray() {
        return this.map.toSortedArray();
    }

    @Override
    public MutableFloatList toSortedList() {
        return this.map.toSortedList();
    }

    @Override
    public float[] toArray() {
        return this.map.toArray();
    }

    @Override
    public boolean contains(float value) {
        return this.map.contains(value);
    }

    @Override
    public boolean containsAll(float ... source) {
        return this.map.containsAll(source);
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        return this.map.containsAll(source);
    }

    @Override
    public MutableFloatList toList() {
        return this.map.toList();
    }

    @Override
    public MutableFloatSet toSet() {
        return this.map.toSet();
    }

    @Override
    public MutableFloatBag toBag() {
        return this.map.toBag();
    }

    @Override
    public LazyFloatIterable asLazy() {
        return this.map.asLazy();
    }

    @Override
    public MutableObjectFloatMap<K> withKeyValue(K key, float value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableObjectFloatMap<K> withoutKey(K key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableObjectFloatMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableObjectFloatMap<K> asUnmodifiable() {
        return this;
    }

    @Override
    public MutableObjectFloatMap<K> asSynchronized() {
        return new SynchronizedObjectFloatMap(this);
    }

    @Override
    public ImmutableObjectFloatMap<K> toImmutable() {
        return ObjectFloatMaps.immutable.withAll(this);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(this.map.values());
    }

    @Override
    public LazyIterable<K> keysView() {
        return this.map.keysView();
    }

    @Override
    public RichIterable<ObjectFloatPair<K>> keyValuesView() {
        return this.map.keyValuesView();
    }

    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public String makeString() {
        return this.map.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return this.map.injectInto(injectedValue, function);
    }
}

