/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectDoublePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.iterator.MutableDoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.ImmutableObjectDoubleMap;
import com.gs.collections.api.map.primitive.MutableObjectDoubleMap;
import com.gs.collections.api.map.primitive.ObjectDoubleMap;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.tuple.primitive.ObjectDoublePair;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedDoubleCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.factory.primitive.ObjectDoubleMaps;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedObjectDoubleMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableObjectDoubleMap;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDoubleHashMap<K>
implements MutableObjectDoubleMap<K>,
Externalizable {
    public static final double EMPTY_VALUE = 0.0;
    private static final long serialVersionUID = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectDoubleHashMap.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectDoubleHashMap.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private double[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;

    public ObjectDoubleHashMap() {
        this.allocateTable(16);
    }

    public ObjectDoubleHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public ObjectDoubleHashMap(ObjectDoubleMap<? extends K> map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static <K> ObjectDoubleHashMap<K> newMap() {
        return new ObjectDoubleHashMap<K>();
    }

    public static <K> ObjectDoubleHashMap<K> newWithKeysValues(K key1, double value1) {
        return new ObjectDoubleHashMap<K>(1).withKeyValue((Object)key1, value1);
    }

    public static <K> ObjectDoubleHashMap<K> newWithKeysValues(K key1, double value1, K key2, double value2) {
        return new ObjectDoubleHashMap<K>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectDoubleHashMap<K> newWithKeysValues(K key1, double value1, K key2, double value2, K key3, double value3) {
        return new ObjectDoubleHashMap<K>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectDoubleHashMap<K> newWithKeysValues(K key1, double value1, K key2, double value2, K key3, double value3, K key4, double value4) {
        return new ObjectDoubleHashMap<K>(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectDoubleMap)) {
            return false;
        }
        ObjectDoubleMap other = (ObjectDoubleMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && Double.compare(this.values[i], other.getOrThrow(this.toNonSentinel(this.keys[i]))) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += (this.toNonSentinel(this.keys[i]) == null ? 0 : this.keys[i].hashCode()) ^ (int)(Double.doubleToLongBits(this.values[i]) ^ Double.doubleToLongBits(this.values[i]) >>> 32);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectDoubleHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public int size() {
        return this.occupiedWithData;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean notEmpty() {
        return this.size() != 0;
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectDoubleHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(String.valueOf(this.values[i])));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableDoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    @Override
    public double[] toArray() {
        double[] result = new double[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    @Override
    public boolean contains(double value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsAll(double ... source) {
        for (double item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        return this.containsAll(source.toArray());
    }

    @Override
    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, 0.0);
    }

    @Override
    public void put(K key, double value) {
        int index = this.probe(key);
        if (ObjectDoubleHashMap.isNonSentinel(this.keys[index]) && ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    @Override
    public void putAll(ObjectDoubleMap<? extends K> map) {
        map.forEachKeyValue(new ObjectDoubleProcedure<K>(){

            @Override
            public void value(K key, double value) {
                ObjectDoubleHashMap.this.put(key, value);
            }
        });
    }

    @Override
    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    private void removeKeyAtIndex(K key, int index) {
        if (ObjectDoubleHashMap.isNonSentinel(this.keys[index]) && ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    @Override
    public void remove(Object key) {
        this.removeKey(key);
    }

    @Override
    public double removeKeyIfAbsent(K key, double value) {
        int index = this.probe(key);
        if (ObjectDoubleHashMap.isNonSentinel(this.keys[index]) && ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            double oldValue = this.values[index];
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    @Override
    public double getIfAbsentPut(K key, double value) {
        int index = this.probe(key);
        if (ObjectDoubleHashMap.isNonSentinel(this.keys[index]) && ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public double getIfAbsentPut(K key, DoubleFunction0 function) {
        int index = this.probe(key);
        if (ObjectDoubleHashMap.isNonSentinel(this.keys[index]) && ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        double value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> double getIfAbsentPutWith(K key, DoubleFunction<? super P> function, P parameter) {
        int index = this.probe(key);
        if (ObjectDoubleHashMap.isNonSentinel(this.keys[index]) && ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        double value = function.doubleValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public double getIfAbsentPutWithKey(K key, DoubleFunction<? super K> function) {
        int index = this.probe(key);
        if (ObjectDoubleHashMap.isNonSentinel(this.keys[index]) && ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        double value = function.doubleValueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public double updateValue(K key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        int index = this.probe(key);
        if (ObjectDoubleHashMap.isNonSentinel(this.keys[index]) && ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        double value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(K key, double value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectDoubleHashMap.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    @Override
    public double addToValue(K key, double toBeAdded) {
        int index = this.probe(key);
        if (ObjectDoubleHashMap.isNonSentinel(this.keys[index]) && ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    @Override
    public ObjectDoubleHashMap<K> withKeyValue(K key1, double value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectDoubleHashMap<K> withKeysValues(K key1, double value1, K key2, double value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectDoubleHashMap<K> withKeysValues(K key1, double value1, K key2, double value2, K key3, double value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectDoubleHashMap<K> withKeysValues(K key1, double value1, K key2, double value2, K key3, double value3, K key4, double value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public ObjectDoubleHashMap<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public ObjectDoubleHashMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    @Override
    public MutableObjectDoubleMap<K> asUnmodifiable() {
        return new UnmodifiableObjectDoubleMap(this);
    }

    @Override
    public MutableObjectDoubleMap<K> asSynchronized() {
        return new SynchronizedObjectDoubleMap(this);
    }

    @Override
    public ImmutableObjectDoubleMap<K> toImmutable() {
        return ObjectDoubleMaps.immutable.withAll(this);
    }

    @Override
    public double get(Object key) {
        return this.getIfAbsent(key, 0.0);
    }

    @Override
    public double getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectDoubleHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public double getIfAbsent(Object key, double ifAbsent) {
        int index = this.probe(key);
        if (ObjectDoubleHashMap.isNonSentinel(this.keys[index]) && ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectDoubleHashMap.isNonSentinel(this.keys[index]) && ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    @Override
    public boolean containsValue(double value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || Double.compare(this.values[i], value) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        this.forEachValue(procedure);
    }

    @Override
    public void forEachValue(DoubleProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    @Override
    public void forEachKeyValue(ObjectDoubleProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    @Override
    public ObjectDoubleHashMap<K> select(ObjectDoublePredicate<? super K> predicate) {
        ObjectDoubleHashMap<K> result = ObjectDoubleHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    @Override
    public ObjectDoubleHashMap<K> reject(ObjectDoublePredicate<? super K> predicate) {
        ObjectDoubleHashMap<K> result = ObjectDoubleHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    @Override
    public MutableDoubleCollection select(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableDoubleCollection reject(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return ifNone;
    }

    @Override
    public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        FastList<V> result = FastList.newList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values[i]));
        }
        return result;
    }

    @Override
    public int count(DoublePredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public double sum() {
        double result = 0.0;
        double compensation = 0.0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            double adjustedValue = this.values[i] - compensation;
            double nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        return result;
    }

    @Override
    public double max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        double max = 0.0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || isMaxSet && Double.compare(max, this.values[i]) >= 0) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public double min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        double min = 0.0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || isMinSet && Double.compare(this.values[i], min) >= 0) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        double max = 0.0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || isMaxSet && Double.compare(max, this.values[i]) >= 0) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        double min = 0.0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i]) || isMinSet && Double.compare(this.values[i], min) >= 0) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public MutableDoubleList toList() {
        DoubleArrayList result = new DoubleArrayList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableDoubleSet toSet() {
        DoubleHashSet result = new DoubleHashSet(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableDoubleBag toBag() {
        DoubleHashBag result = new DoubleHashBag(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableDoubleList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size * 2));
        this.allocateTable(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(in.readObject(), in.readDouble());
        }
    }

    @Override
    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<ObjectDoublePair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        double[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectDoubleHashMap.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectDoubleHashMap.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectDoubleHashMap.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (ObjectDoubleHashMap.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        int h = element == null ? 0 : element.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.keys.length - 1;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new double[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectDoubleHashMap.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public MutableDoubleCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ Object[] access$302(ObjectDoubleHashMap x0, Object[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ double[] access$502(ObjectDoubleHashMap x0, double[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<ObjectDoublePair<K>> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super ObjectDoublePair<K>> procedure) {
            for (int i = 0; i < ObjectDoubleHashMap.this.keys.length; ++i) {
                if (!ObjectDoubleHashMap.isNonSentinel(ObjectDoubleHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectDoubleHashMap.this.toNonSentinel(ObjectDoubleHashMap.this.keys[i]), ObjectDoubleHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ObjectDoublePair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectDoubleHashMap.this.keys.length; ++i) {
                if (!ObjectDoubleHashMap.isNonSentinel(ObjectDoubleHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectDoubleHashMap.this.toNonSentinel(ObjectDoubleHashMap.this.keys[i]), ObjectDoubleHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ObjectDoublePair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectDoubleHashMap.this.keys.length; ++i) {
                if (!ObjectDoubleHashMap.isNonSentinel(ObjectDoubleHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectDoubleHashMap.this.toNonSentinel(ObjectDoubleHashMap.this.keys[i]), ObjectDoubleHashMap.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<ObjectDoublePair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<ObjectDoublePair<K>> {
            private int count;
            private int position;

            @Override
            public ObjectDoublePair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectDoubleHashMap.this.keys;
                while (!ObjectDoubleHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ObjectDoublePair<Object> result = PrimitiveTuples.pair(ObjectDoubleHashMap.this.toNonSentinel(ObjectDoubleHashMap.this.keys[this.position]), ObjectDoubleHashMap.this.values[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectDoubleHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        @Override
        public void each(Procedure<? super K> procedure) {
            ObjectDoubleHashMap.this.forEachKey(procedure);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super K> objectDoubleProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectDoubleHashMap.this.keys.length; ++i) {
                if (!ObjectDoubleHashMap.isNonSentinel(ObjectDoubleHashMap.this.keys[i])) continue;
                objectDoubleProcedure.value(ObjectDoubleHashMap.this.toNonSentinel(ObjectDoubleHashMap.this.keys[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectDoubleHashMap.this.keys.length; ++i) {
                if (!ObjectDoubleHashMap.isNonSentinel(ObjectDoubleHashMap.this.keys[i])) continue;
                procedure.value(ObjectDoubleHashMap.this.toNonSentinel(ObjectDoubleHashMap.this.keys[i]), parameter);
            }
        }

        @Override
        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeysViewIterator
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectDoubleHashMap.this.keys;
                while (!ObjectDoubleHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                Object result = ObjectDoubleHashMap.this.toNonSentinel(ObjectDoubleHashMap.this.keys[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectDoubleHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableDoubleCollection {
        private ValuesCollection() {
        }

        @Override
        public int size() {
            return ObjectDoubleHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectDoubleHashMap.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return ObjectDoubleHashMap.this.notEmpty();
        }

        @Override
        public String makeString() {
            return this.makeString(", ");
        }

        @Override
        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        @Override
        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        @Override
        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        @Override
        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectDoubleHashMap.this.keys.length; ++i) {
                    Object key = ObjectDoubleHashMap.this.keys[i];
                    if (!ObjectDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectDoubleHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean add(double element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(double ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(DoubleIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(double item) {
            int oldSize = ObjectDoubleHashMap.this.size();
            for (int i = 0; i < ObjectDoubleHashMap.this.keys.length; ++i) {
                if (!ObjectDoubleHashMap.isNonSentinel(ObjectDoubleHashMap.this.keys[i]) || Double.compare(item, ObjectDoubleHashMap.this.values[i]) != 0) continue;
                ObjectDoubleHashMap.this.removeKey(ObjectDoubleHashMap.this.keys[i]);
            }
            return oldSize != ObjectDoubleHashMap.this.size();
        }

        @Override
        public boolean removeAll(DoubleIterable source) {
            int oldSize = ObjectDoubleHashMap.this.size();
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ObjectDoubleHashMap.this.size();
        }

        @Override
        public boolean removeAll(double ... source) {
            int oldSize = ObjectDoubleHashMap.this.size();
            for (double item : source) {
                this.remove(item);
            }
            return oldSize != ObjectDoubleHashMap.this.size();
        }

        @Override
        public boolean retainAll(DoubleIterable source) {
            int oldSize = ObjectDoubleHashMap.this.size();
            final DoubleSet sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            MutableObjectDoubleMap retained = ObjectDoubleHashMap.this.select(new ObjectDoublePredicate<K>(){

                @Override
                public boolean accept(K object, double value) {
                    return sourceSet.contains(value);
                }
            });
            if (((ObjectDoubleHashMap)retained).size() != oldSize) {
                ObjectDoubleHashMap.access$302(ObjectDoubleHashMap.this, ((ObjectDoubleHashMap)retained).keys);
                ObjectDoubleHashMap.access$502(ObjectDoubleHashMap.this, ((ObjectDoubleHashMap)retained).values);
                ObjectDoubleHashMap.this.occupiedWithData = ((ObjectDoubleHashMap)retained).occupiedWithData;
                ObjectDoubleHashMap.this.occupiedWithSentinels = ((ObjectDoubleHashMap)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(double ... source) {
            return this.retainAll(DoubleHashSet.newSetWith(source));
        }

        @Override
        public void clear() {
            ObjectDoubleHashMap.this.clear();
        }

        @Override
        public MutableDoubleCollection with(double element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableDoubleCollection without(double element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableDoubleCollection withAll(DoubleIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableDoubleCollection withoutAll(DoubleIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableDoubleCollection asUnmodifiable() {
            return UnmodifiableDoubleCollection.of(this);
        }

        @Override
        public MutableDoubleCollection asSynchronized() {
            return SynchronizedDoubleCollection.of(this);
        }

        @Override
        public ImmutableDoubleCollection toImmutable() {
            return DoubleLists.immutable.withAll(this);
        }

        @Override
        public MutableDoubleIterator doubleIterator() {
            return ObjectDoubleHashMap.this.doubleIterator();
        }

        @Override
        public double[] toArray() {
            return ObjectDoubleHashMap.this.toArray();
        }

        @Override
        public boolean contains(double value) {
            return ObjectDoubleHashMap.this.containsValue(value);
        }

        @Override
        public boolean containsAll(double ... source) {
            return ObjectDoubleHashMap.this.containsAll(source);
        }

        @Override
        public boolean containsAll(DoubleIterable source) {
            return ObjectDoubleHashMap.this.containsAll(source);
        }

        @Override
        public void forEach(DoubleProcedure procedure) {
            this.each(procedure);
        }

        @Override
        public void each(DoubleProcedure procedure) {
            ObjectDoubleHashMap.this.forEach(procedure);
        }

        @Override
        public MutableDoubleCollection select(DoublePredicate predicate) {
            return ObjectDoubleHashMap.this.select(predicate);
        }

        @Override
        public MutableDoubleCollection reject(DoublePredicate predicate) {
            return ObjectDoubleHashMap.this.reject(predicate);
        }

        @Override
        public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
            return ObjectDoubleHashMap.this.collect((DoubleToObjectFunction)function);
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
            return ObjectDoubleHashMap.this.injectInto(injectedValue, function);
        }

        @Override
        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            return ObjectDoubleHashMap.this.detectIfNone(predicate, ifNone);
        }

        @Override
        public int count(DoublePredicate predicate) {
            return ObjectDoubleHashMap.this.count(predicate);
        }

        @Override
        public boolean anySatisfy(DoublePredicate predicate) {
            return ObjectDoubleHashMap.this.anySatisfy(predicate);
        }

        @Override
        public boolean allSatisfy(DoublePredicate predicate) {
            return ObjectDoubleHashMap.this.allSatisfy(predicate);
        }

        @Override
        public boolean noneSatisfy(DoublePredicate predicate) {
            return ObjectDoubleHashMap.this.noneSatisfy(predicate);
        }

        @Override
        public MutableDoubleList toList() {
            return ObjectDoubleHashMap.this.toList();
        }

        @Override
        public MutableDoubleSet toSet() {
            return ObjectDoubleHashMap.this.toSet();
        }

        @Override
        public MutableDoubleBag toBag() {
            return ObjectDoubleHashMap.this.toBag();
        }

        @Override
        public LazyDoubleIterable asLazy() {
            return new LazyDoubleIterableAdapter(this);
        }

        @Override
        public double[] toSortedArray() {
            return ObjectDoubleHashMap.this.toSortedArray();
        }

        @Override
        public MutableDoubleList toSortedList() {
            return ObjectDoubleHashMap.this.toSortedList();
        }

        @Override
        public double sum() {
            return ObjectDoubleHashMap.this.sum();
        }

        @Override
        public double max() {
            return ObjectDoubleHashMap.this.max();
        }

        @Override
        public double maxIfEmpty(double defaultValue) {
            return ObjectDoubleHashMap.this.maxIfEmpty(defaultValue);
        }

        @Override
        public double min() {
            return ObjectDoubleHashMap.this.min();
        }

        @Override
        public double minIfEmpty(double defaultValue) {
            return ObjectDoubleHashMap.this.minIfEmpty(defaultValue);
        }

        @Override
        public double average() {
            return ObjectDoubleHashMap.this.average();
        }

        @Override
        public double median() {
            return ObjectDoubleHashMap.this.median();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectDoubleHashMap.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys = ObjectDoubleHashMap.this.keys;
            while (!ObjectDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectDoubleHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectDoubleHashMap.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectDoubleHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ObjectDoubleHashMap.this.removeKeyAtIndex(ObjectDoubleHashMap.this.toNonSentinel(this.currentKey), index);
            } else {
                ObjectDoubleHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] table = ObjectDoubleHashMap.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectDoubleHashMap.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectDoubleHashMap.this.toNonSentinel(key);
                hashCode += nonSentinelKey == null ? 0 : nonSentinelKey.hashCode();
            }
            return hashCode;
        }

        @Override
        public int size() {
            return ObjectDoubleHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectDoubleHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectDoubleHashMap.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size = ObjectDoubleHashMap.this.size();
            Object[] result = new Object[size];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size = ObjectDoubleHashMap.this.size();
            if (result.length < size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
            }
            this.copyKeys(result);
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectDoubleHashMap.this.size();
            ObjectDoubleHashMap.this.removeKey(key);
            return oldSize != ObjectDoubleHashMap.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectDoubleHashMap.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectDoubleHashMap.this.size();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (collection.contains(next)) continue;
                iterator.remove();
            }
            return oldSize != ObjectDoubleHashMap.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectDoubleHashMap.this.size();
            for (Object object : collection) {
                ObjectDoubleHashMap.this.removeKey(object);
            }
            return oldSize != ObjectDoubleHashMap.this.size();
        }

        @Override
        public void clear() {
            ObjectDoubleHashMap.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count = 0;
            for (int i = 0; i < ObjectDoubleHashMap.this.keys.length; ++i) {
                Object key = ObjectDoubleHashMap.this.keys[i];
                if (!ObjectDoubleHashMap.isNonSentinel(key)) continue;
                result[count++] = ObjectDoubleHashMap.this.keys[i];
            }
        }
    }

    private class InternalDoubleIterator
    implements MutableDoubleIterator {
        private int count;
        private int position;

        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return this.count != ObjectDoubleHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys = ObjectDoubleHashMap.this.keys;
            while (!ObjectDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = ObjectDoubleHashMap.this.values[this.position];
            ++this.count;
            ++this.position;
            return result;
        }

        public void remove() {
            if (this.position == 0 || !ObjectDoubleHashMap.isNonSentinel(ObjectDoubleHashMap.this.keys[this.position - 1])) {
                throw new IllegalStateException();
            }
            ObjectDoubleHashMap.this.remove(ObjectDoubleHashMap.this.keys[this.position - 1]);
            --this.count;
        }
    }
}

