/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharCharPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.CharCharProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.MutableCharIterator;
import com.gs.collections.api.map.primitive.CharCharMap;
import com.gs.collections.api.map.primitive.ImmutableCharCharMap;
import com.gs.collections.api.map.primitive.MutableCharCharMap;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.tuple.primitive.CharCharPair;
import com.gs.collections.impl.SpreadFunctions;
import com.gs.collections.impl.factory.primitive.CharCharMaps;
import com.gs.collections.impl.iterator.UnmodifiableCharIterator;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableCharKeySet;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableCharValuesMap;
import com.gs.collections.impl.map.mutable.primitive.ImmutableCharCharMapKeySet;
import com.gs.collections.impl.map.mutable.primitive.MutableCharKeysMap;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedCharCharMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableCharCharMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharCharHashMap
extends AbstractMutableCharValuesMap
implements MutableCharCharMap,
Externalizable,
MutableCharKeysMap {
    private static final char EMPTY_VALUE = '\u0000';
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 2;
    private static final int INITIAL_LINEAR_PROBE = 16;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private char[] keysValues;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableCharValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public CharCharHashMap() {
        this.allocateTable(16);
    }

    public CharCharHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public CharCharHashMap(CharCharMap map) {
        if (map instanceof CharCharHashMap && ((CharCharHashMap)map).occupiedWithSentinels == 0) {
            CharCharHashMap hashMap = (CharCharHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keysValues = Arrays.copyOf(hashMap.keysValues, hashMap.keysValues.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static CharCharHashMap newWithKeysValues(char key1, char value1) {
        return new CharCharHashMap(1).withKeyValue(key1, value1);
    }

    public static CharCharHashMap newWithKeysValues(char key1, char value1, char key2, char value2) {
        return new CharCharHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static CharCharHashMap newWithKeysValues(char key1, char value1, char key2, char value2, char key3, char value3) {
        return new CharCharHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static CharCharHashMap newWithKeysValues(char key1, char value1, char key2, char value2, char key3, char value3, char key4, char value4) {
        return new CharCharHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableCharValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected char getEmptyValue() {
        return '\u0000';
    }

    @Override
    protected int getTableSize() {
        return this.keysValues.length / 2;
    }

    @Override
    protected char getValueAtIndex(int index) {
        return this.keysValues[index * 2 + 1];
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharCharMap)) {
            return false;
        }
        CharCharMap other = (CharCharMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey('\u0000') || other.containsKey('\u0001')) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey('\u0000') || this.sentinelValues.zeroValue != other.getOrThrow('\u0000'))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey('\u0001') || this.sentinelValues.oneValue != other.getOrThrow('\u0001'))) {
                return false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            char key = this.keysValues[i];
            if (!CharCharHashMap.isNonSentinel(key) || other.containsKey(key) && this.keysValues[i + 1] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += '\u0000' ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += '\u0001' ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!CharCharHashMap.isNonSentinel(this.keysValues[i])) continue;
            result += this.keysValues[i] ^ this.keysValues[i + 1];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append('\u0000').append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append('\u0001').append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            char key = this.keysValues[i];
            if (!CharCharHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.keysValues[i + 1]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public MutableCharIterator charIterator() {
        return new InternalCharIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectCharToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!CharCharHashMap.isNonSentinel(this.keysValues[i])) continue;
            result = function.valueOf(result, this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keysValues, '\u0000');
    }

    @Override
    public void put(char key, char value) {
        if (CharCharHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        char keyAtIndex = this.keysValues[index];
        if (keyAtIndex == key) {
            this.keysValues[index + 1] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(char value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(char value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    @Override
    public void putAll(CharCharMap map) {
        map.forEachKeyValue(new CharCharProcedure(){

            public void value(char key, char value) {
                CharCharHashMap.this.put(key, value);
            }
        });
    }

    @Override
    public void removeKey(char key) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    @Override
    public void remove(char key) {
        this.removeKey(key);
    }

    @Override
    public char removeKeyIfAbsent(char key, char value) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            char oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            char oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            char oldValue = this.keysValues[index + 1];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    @Override
    public char getIfAbsentPut(char key, char value) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public char getIfAbsentPut(char key, CharFunction0 function) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.value();
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.value();
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        char value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> char getIfAbsentPutWith(char key, CharFunction<? super P> function, P parameter) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.charValueOf(parameter);
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value = function.charValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.charValueOf(parameter);
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value = function.charValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        char value = function.charValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public char getIfAbsentPutWithKey(char key, CharToCharFunction function) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        char value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public char addToValue(char key, char toBeAdded) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (char)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (char)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            int n = index + 1;
            this.keysValues[n] = (char)(this.keysValues[n] + toBeAdded);
            return this.keysValues[index + 1];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.keysValues[index + 1];
    }

    private void addKeyValueAtIndex(char key, char value, int index) {
        if (this.keysValues[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keysValues[index] = key;
        this.keysValues[index + 1] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keysValues[index] = '\u0001';
        this.keysValues[index + 1] = '\u0000';
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        char[] copy = new char[this.keysValues.length];
        System.arraycopy(this.keysValues, 0, copy, 0, this.keysValues.length);
        this.keysValues = copy;
        this.copyKeysOnWrite = false;
    }

    @Override
    public char updateValue(char key, char initialValueIfAbsent, CharToCharFunction function) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            this.keysValues[index + 1] = function.valueOf(this.keysValues[index + 1]);
            return this.keysValues[index + 1];
        }
        char value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public CharCharHashMap withKeyValue(char key1, char value1) {
        this.put(key1, value1);
        return this;
    }

    public CharCharHashMap withKeysValues(char key1, char value1, char key2, char value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public CharCharHashMap withKeysValues(char key1, char value1, char key2, char value2, char key3, char value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public CharCharHashMap withKeysValues(char key1, char value1, char key2, char value2, char key3, char value3, char key4, char value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public CharCharHashMap withoutKey(char key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public CharCharHashMap withoutAllKeys(CharIterable keys) {
        keys.forEach(new CharProcedure(){

            public void value(char key) {
                CharCharHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    @Override
    public MutableCharCharMap asUnmodifiable() {
        return new UnmodifiableCharCharMap(this);
    }

    @Override
    public MutableCharCharMap asSynchronized() {
        return new SynchronizedCharCharMap(this);
    }

    @Override
    public ImmutableCharCharMap toImmutable() {
        return CharCharMaps.immutable.ofAll(this);
    }

    @Override
    public char get(char key) {
        return this.getIfAbsent(key, '\u0000');
    }

    @Override
    public char getIfAbsent(char key, char ifAbsent) {
        if (CharCharHashMap.isEmptyKey(key) || CharCharHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private char getForSentinel(char key, char ifAbsent) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private char slowGetIfAbsent(char key, char ifAbsent) {
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        return ifAbsent;
    }

    private char fastGetIfAbsent(char key, char ifAbsent) {
        int index = this.mask(key) << 1;
        for (int i = 0; i < 16; i += 2) {
            char keyAtIndex = this.keysValues[index];
            if (keyAtIndex == key) {
                return this.keysValues[index + 1];
            }
            if (keyAtIndex == '\u0000') {
                return ifAbsent;
            }
            index = index + 2 & this.keysValues.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private char slowGetIfAbsentTwo(char key, char ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        return ifAbsent;
    }

    @Override
    public char getOrThrow(char key) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (CharCharHashMap.isNonSentinel(this.keysValues[index])) {
            return this.keysValues[index + 1];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(char key) {
        if (CharCharHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keysValues[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000');
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001');
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!CharCharHashMap.isNonSentinel(this.keysValues[i])) continue;
            procedure.value(this.keysValues[i]);
        }
    }

    @Override
    public void forEachKeyValue(CharCharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!CharCharHashMap.isNonSentinel(this.keysValues[i])) continue;
            procedure.value(this.keysValues[i], this.keysValues[i + 1]);
        }
    }

    @Override
    public LazyCharIterable keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<CharCharPair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public CharCharHashMap select(CharCharPredicate predicate) {
        CharCharHashMap result = new CharCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!CharCharHashMap.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            result.put(this.keysValues[i], this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public CharCharHashMap reject(CharCharPredicate predicate) {
        CharCharHashMap result = new CharCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!CharCharHashMap.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            result.put(this.keysValues[i], this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeChar(0);
                out.writeChar(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeChar(1);
                out.writeChar(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!CharCharHashMap.isNonSentinel(this.keysValues[i])) continue;
            out.writeChar(this.keysValues[i]);
            out.writeChar(this.keysValues[i + 1]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readChar(), in.readChar());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        this.rehash(this.keysValues.length);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keysValues.length;
        char[] old = this.keysValues;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; i += 2) {
            if (!CharCharHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], old[i + 1]);
        }
    }

    int probe(char element) {
        int index = this.mask(element) << 1;
        char keyAtIndex = this.keysValues[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        for (int i = 2; i < 16; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(char element, int removedIndex) {
        int index = this.spreadTwoAndMask(element) << 1;
        for (int i = 0; i < 16; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            char keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(char element, int removedIndex) {
        int nextIndex = SpreadFunctions.charSpreadOne(element) << 1;
        int spreadTwo = Integer.reverse(SpreadFunctions.charSpreadTwo(element)) | 1;
        char keyAtIndex;
        while ((keyAtIndex = this.keysValues[nextIndex = this.mask((nextIndex >> 1) + spreadTwo) << 1]) != element) {
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(char element) {
        int code = SpreadFunctions.charSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(char element) {
        int code = SpreadFunctions.charSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & (this.keysValues.length >> 1) - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keysValues = new char[sizeToAllocate << 1];
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !CharCharHashMap.isEmptyKey(key) && !CharCharHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !CharCharHashMap.isEmptyKey(this.keysValues[index * 2]) && !CharCharHashMap.isRemovedKey(this.keysValues[index * 2]);
    }

    private int maxOccupiedWithData() {
        return this.keysValues.length >> 2;
    }

    private int maxOccupiedWithSentinels() {
        return this.keysValues.length >> 3;
    }

    @Override
    public MutableCharSet keySet() {
        return new KeySet();
    }

    @Override
    public MutableCharCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ char[] access$302(CharCharHashMap x0, char[] x1) {
        x0.keysValues = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<CharCharPair> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super CharCharPair> procedure) {
            if (CharCharHashMap.this.sentinelValues != null) {
                if (((CharCharHashMap)CharCharHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair('\u0000', ((CharCharHashMap)CharCharHashMap.this).sentinelValues.zeroValue));
                }
                if (((CharCharHashMap)CharCharHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair('\u0001', ((CharCharHashMap)CharCharHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < CharCharHashMap.this.keysValues.length; i += 2) {
                if (!CharCharHashMap.isNonSentinel(CharCharHashMap.this.keysValues[i])) continue;
                procedure.value(PrimitiveTuples.pair(CharCharHashMap.this.keysValues[i], CharCharHashMap.this.keysValues[i + 1]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super CharCharPair> objectIntProcedure) {
            int index = 0;
            if (CharCharHashMap.this.sentinelValues != null) {
                if (((CharCharHashMap)CharCharHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair('\u0000', ((CharCharHashMap)CharCharHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((CharCharHashMap)CharCharHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair('\u0001', ((CharCharHashMap)CharCharHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < CharCharHashMap.this.keysValues.length; i += 2) {
                if (!CharCharHashMap.isNonSentinel(CharCharHashMap.this.keysValues[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(CharCharHashMap.this.keysValues[i], CharCharHashMap.this.keysValues[i + 1]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super CharCharPair, ? super P> procedure, P parameter) {
            if (CharCharHashMap.this.sentinelValues != null) {
                if (((CharCharHashMap)CharCharHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair('\u0000', ((CharCharHashMap)CharCharHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((CharCharHashMap)CharCharHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair('\u0001', ((CharCharHashMap)CharCharHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < CharCharHashMap.this.keysValues.length; i += 2) {
                if (!CharCharHashMap.isNonSentinel(CharCharHashMap.this.keysValues[i])) continue;
                procedure.value(PrimitiveTuples.pair(CharCharHashMap.this.keysValues[i], CharCharHashMap.this.keysValues[i + 1]), parameter);
            }
        }

        @Override
        public Iterator<CharCharPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<CharCharPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public CharCharPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (CharCharHashMap.this.containsKey('\u0000')) {
                        return PrimitiveTuples.pair('\u0000', ((CharCharHashMap)CharCharHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (CharCharHashMap.this.containsKey('\u0001')) {
                        return PrimitiveTuples.pair('\u0001', ((CharCharHashMap)CharCharHashMap.this).sentinelValues.oneValue);
                    }
                }
                char[] keys = CharCharHashMap.this.keysValues;
                while (!CharCharHashMap.isNonSentinel(keys[this.position])) {
                    this.position += 2;
                }
                CharCharPair result = PrimitiveTuples.pair(keys[this.position], CharCharHashMap.this.keysValues[this.position + 1]);
                this.position += 2;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != CharCharHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableCharValuesMap.AbstractCharValuesCollection {
        private ValuesCollection() {
        }

        public MutableCharIterator charIterator() {
            return CharCharHashMap.this.charIterator();
        }

        public boolean remove(char item) {
            int oldSize = CharCharHashMap.this.size();
            if (CharCharHashMap.this.sentinelValues != null) {
                if (((CharCharHashMap)CharCharHashMap.this).sentinelValues.containsZeroKey && item == ((CharCharHashMap)CharCharHashMap.this).sentinelValues.zeroValue) {
                    CharCharHashMap.this.removeKey('\u0000');
                }
                if (((CharCharHashMap)CharCharHashMap.this).sentinelValues.containsOneKey && item == ((CharCharHashMap)CharCharHashMap.this).sentinelValues.oneValue) {
                    CharCharHashMap.this.removeKey('\u0001');
                }
            }
            for (int i = 0; i < CharCharHashMap.this.keysValues.length; i += 2) {
                if (!CharCharHashMap.isNonSentinel(CharCharHashMap.this.keysValues[i]) || item != CharCharHashMap.this.keysValues[i + 1]) continue;
                CharCharHashMap.this.removeKey(CharCharHashMap.this.keysValues[i]);
            }
            return oldSize != CharCharHashMap.this.size();
        }

        public boolean retainAll(CharIterable source) {
            int oldSize = CharCharHashMap.this.size();
            final CharSet sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            CharCharHashMap retained = CharCharHashMap.this.select(new CharCharPredicate(){

                public boolean accept(char key, char value) {
                    return sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                CharCharHashMap.access$302(CharCharHashMap.this, retained.keysValues);
                CharCharHashMap.this.sentinelValues = retained.sentinelValues;
                CharCharHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharCharHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }
    }

    private class KeySet
    extends AbstractMutableCharKeySet {
        private KeySet() {
        }

        protected MutableCharKeysMap getOuter() {
            return CharCharHashMap.this;
        }

        protected AbstractMutableCharValuesMap.SentinelValues getSentinelValues() {
            return CharCharHashMap.this.sentinelValues;
        }

        protected char getKeyAtIndex(int index) {
            return CharCharHashMap.this.keysValues[index * 2];
        }

        protected int getTableSize() {
            return CharCharHashMap.this.keysValues.length / 2;
        }

        public MutableCharIterator charIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(CharIterable source) {
            int oldSize = CharCharHashMap.this.size();
            final CharSet sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            CharCharHashMap retained = CharCharHashMap.this.select(new CharCharPredicate(){

                public boolean accept(char key, char value) {
                    return sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                CharCharHashMap.access$302(CharCharHashMap.this, retained.keysValues);
                CharCharHashMap.this.sentinelValues = retained.sentinelValues;
                CharCharHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharCharHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(char ... source) {
            return this.retainAll(CharHashSet.newSetWith(source));
        }

        public CharSet freeze() {
            CharCharHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (CharCharHashMap.this.sentinelValues != null) {
                containsZeroKey = ((CharCharHashMap)CharCharHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((CharCharHashMap)CharCharHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableCharCharMapKeySet(CharCharHashMap.this.keysValues, CharCharHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }
    }

    private class KeySetIterator
    implements MutableCharIterator {
        private int count;
        private int position;
        private char lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < CharCharHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharCharHashMap.this.containsKey('\u0000')) {
                    this.lastKey = '\u0000';
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharCharHashMap.this.containsKey('\u0001')) {
                    this.lastKey = '\u0001';
                    return this.lastKey;
                }
            }
            char[] keys = CharCharHashMap.this.keysValues;
            while (!CharCharHashMap.isNonSentinel(keys[this.position])) {
                this.position += 2;
            }
            this.lastKey = keys[this.position];
            this.position += 2;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            CharCharHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyCharIterable {
        private KeysView() {
        }

        public CharIterator charIterator() {
            return new UnmodifiableCharIterator(new KeySetIterator());
        }

        public void each(CharProcedure procedure) {
            CharCharHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalCharIterator
    implements MutableCharIterator {
        private int count;
        private int position;
        private char lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalCharIterator() {
        }

        public boolean hasNext() {
            return this.count < CharCharHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharCharHashMap.this.containsKey('\u0000')) {
                    this.lastKey = '\u0000';
                    return CharCharHashMap.this.get('\u0000');
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharCharHashMap.this.containsKey('\u0001')) {
                    this.lastKey = '\u0001';
                    return CharCharHashMap.this.get('\u0001');
                }
            }
            char[] keys = CharCharHashMap.this.keysValues;
            while (!CharCharHashMap.isNonSentinel(keys[this.position])) {
                this.position += 2;
            }
            this.lastKey = keys[this.position];
            char result = CharCharHashMap.this.keysValues[this.position + 1];
            this.position += 2;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            CharCharHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

