/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.IntSets;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.map.mutable.primitive.AbstractSentinelValues;
import com.gs.collections.impl.map.mutable.primitive.MutableIntKeysMap;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedIntSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableIntKeySet
implements MutableIntSet {
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !AbstractMutableIntKeySet.isEmptyKey(key) && !AbstractMutableIntKeySet.isRemovedKey(key);
    }

    protected abstract int getKeyAtIndex(int var1);

    protected abstract int getTableSize();

    protected abstract MutableIntKeysMap getOuter();

    protected abstract AbstractSentinelValues getSentinelValues();

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        this.getOuter().forEachKey(procedure);
    }

    @Override
    public int count(IntPredicate predicate) {
        int count = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0)) {
                ++count;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1)) {
                ++count;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0)) {
                return true;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1)) {
                return true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(0)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(1)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(int element) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(int ... source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(IntIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableIntSet select(IntPredicate predicate) {
        IntHashSet result = new IntHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0)) {
                result.add(0);
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1)) {
                result.add(1);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public MutableIntSet reject(IntPredicate predicate) {
        IntHashSet result = new IntHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(0)) {
                result.add(0);
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(1)) {
                result.add(1);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public MutableIntSet with(int element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableIntSet without(int element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableIntSet withAll(IntIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableIntSet withoutAll(IntIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public <V> MutableSet<V> collect(IntToObjectFunction<? extends V> function) {
        MutableSet result = Sets.mutable.with();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result.add(function.valueOf(0));
            }
            if (this.getSentinelValues().containsOneKey) {
                result.add(function.valueOf(1));
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result.add(function.valueOf(this.getKeyAtIndex(i)));
        }
        return result;
    }

    @Override
    public boolean remove(int key) {
        int oldSize = this.getOuter().size();
        this.getOuter().removeKey(key);
        return oldSize != this.getOuter().size();
    }

    @Override
    public boolean removeAll(IntIterable source) {
        int oldSize = this.getOuter().size();
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            this.getOuter().removeKey(iterator.next());
        }
        return oldSize != this.getOuter().size();
    }

    @Override
    public boolean removeAll(int ... source) {
        int oldSize = this.getOuter().size();
        for (int item : source) {
            this.getOuter().removeKey(item);
        }
        return oldSize != this.getOuter().size();
    }

    @Override
    public void clear() {
        this.getOuter().clear();
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0)) {
                return 0;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1)) {
                return 1;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return this.getKeyAtIndex(i);
        }
        return ifNone;
    }

    @Override
    public MutableIntSet asUnmodifiable() {
        return UnmodifiableIntSet.of(this);
    }

    @Override
    public MutableIntSet asSynchronized() {
        return SynchronizedIntSet.of(this);
    }

    @Override
    public long sum() {
        long result = 0L;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += 0L;
            }
            if (this.getSentinelValues().containsOneKey) {
                ++result;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result += (long)this.getKeyAtIndex(i);
        }
        return result;
    }

    @Override
    public int max() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        int max = 0;
        boolean isMaxSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                max = 0;
                isMaxSet = true;
            }
            if (this.getSentinelValues().containsOneKey) {
                max = 1;
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMaxSet && max >= this.getKeyAtIndex(i)) continue;
            max = this.getKeyAtIndex(i);
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public int min() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        int min = 0;
        boolean isMinSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                min = 0;
                isMinSet = true;
            }
            if (this.getSentinelValues().containsOneKey && !isMinSet) {
                min = 1;
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMinSet && this.getKeyAtIndex(i) >= min) continue;
            min = this.getKeyAtIndex(i);
            isMinSet = true;
        }
        return min;
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableIntList toSortedList() {
        return IntArrayList.newList(this).sortThis();
    }

    @Override
    public int[] toArray() {
        int size = this.getOuter().size();
        final int[] result = new int[size];
        this.getOuter().forEachKey(new IntProcedure(){
            private int index;

            public void value(int each) {
                result[this.index] = each;
                ++this.index;
            }
        });
        return result;
    }

    @Override
    public boolean contains(int value) {
        return this.getOuter().containsKey(value);
    }

    @Override
    public boolean containsAll(int ... source) {
        for (int item : source) {
            if (this.getOuter().containsKey(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.getOuter().containsKey(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableIntList toList() {
        return IntArrayList.newList(this);
    }

    @Override
    public MutableIntSet toSet() {
        return IntHashSet.newSet(this);
    }

    @Override
    public MutableIntBag toBag() {
        return IntHashBag.newBag(this);
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result = function.valueOf(result, 0);
            }
            if (this.getSentinelValues().containsOneKey) {
                result = function.valueOf(result, 1);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result = function.valueOf(result, this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public ImmutableIntSet toImmutable() {
        return IntSets.immutable.withAll(this);
    }

    @Override
    public int size() {
        return this.getOuter().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getOuter().isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.getOuter().notEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntSet)) {
            return false;
        }
        IntSet other = (IntSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += 0;
            }
            if (this.getSentinelValues().containsOneKey) {
                ++result;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result += this.getKeyAtIndex(i);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.getSentinelValues() != null) {
                if (this.getSentinelValues().containsZeroKey) {
                    appendable.append(String.valueOf(0));
                    first = false;
                }
                if (this.getSentinelValues().containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1));
                    first = false;
                }
            }
            for (int i = 0; i < this.getTableSize(); ++i) {
                if (!AbstractMutableIntKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.getKeyAtIndex(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

