/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortFloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.ImmutableShortFloatMap;
import com.gs.collections.api.map.primitive.MutableShortFloatMap;
import com.gs.collections.api.map.primitive.ShortFloatMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.tuple.primitive.ShortFloatPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedShortFloatProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.map.mutable.primitive.ShortFloatHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableShortFloatHashMap
implements ImmutableShortFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableShortFloatMap delegate;

    ImmutableShortFloatHashMap(ShortFloatMap delegate) {
        this.delegate = new ShortFloatHashMap(delegate);
    }

    @Override
    public float get(short key) {
        return this.delegate.get(key);
    }

    @Override
    public float getIfAbsent(short key, float ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public float getOrThrow(short key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(short key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(float value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(FloatProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(ShortProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ShortFloatProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyShortIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<ShortFloatPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableShortFloatMap select(ShortFloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableShortFloatMap reject(ShortFloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableShortFloatMap toImmutable() {
        return this;
    }

    @Override
    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(this.delegate.floatIterator());
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(FloatProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(FloatPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableFloatCollection select(FloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableFloatCollection reject(FloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public double sum() {
        return this.delegate.sum();
    }

    @Override
    public float max() {
        return this.delegate.max();
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public float min() {
        return this.delegate.min();
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public float[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableFloatList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public float[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(float value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(float ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableFloatList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableFloatSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableFloatBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyFloatIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableShortFloatMap newWithKeyValue(short key, float value) {
        ShortFloatHashMap map = new ShortFloatHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableShortFloatMap newWithoutKey(short key) {
        ShortFloatHashMap map = new ShortFloatHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableShortFloatMap newWithoutAllKeys(ShortIterable keys) {
        ShortFloatHashMap map = new ShortFloatHashMap(this.size());
        map.putAll(this);
        ShortIterator iterator = keys.shortIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableShortSet keySet() {
        return UnmodifiableShortSet.of(this.delegate.keySet());
    }

    @Override
    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableShortFloatMapSerializationProxy(this);
    }

    protected static class ImmutableShortFloatMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ShortFloatMap map;

        public ImmutableShortFloatMapSerializationProxy() {
        }

        protected ImmutableShortFloatMapSerializationProxy(ShortFloatMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedShortFloatProcedure(){

                    public void safeValue(short key, float value) throws IOException {
                        out.writeShort(key);
                        out.writeFloat(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ShortFloatHashMap deserializedMap = new ShortFloatHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readShort(), in.readFloat());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

