/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectFloatPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectFloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.ImmutableObjectFloatMap;
import com.gs.collections.api.map.primitive.ObjectFloatMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.ObjectFloatPair;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.factory.primitive.ObjectFloatMaps;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.map.immutable.primitive.AbstractImmutableObjectFloatMap;
import com.gs.collections.impl.map.immutable.primitive.ImmutableObjectFloatEmptyMap;
import com.gs.collections.impl.map.mutable.primitive.ObjectFloatHashMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableObjectFloatSingletonMap<K>
extends AbstractImmutableObjectFloatMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_VALUE = 0.0f;
    private final K key1;
    private final float value1;

    ImmutableObjectFloatSingletonMap(K key1, float value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(ObjectFloatHashMap.newWithKeysValues(this.key1, this.value1).floatIterator());
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(FloatProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableFloatCollection select(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? FloatLists.immutable.with(this.value1) : FloatLists.immutable.with();
    }

    @Override
    public ImmutableFloatCollection reject(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? FloatLists.immutable.with() : FloatLists.immutable.with(this.value1);
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public double sum() {
        return this.value1;
    }

    @Override
    public float min() {
        return this.value1;
    }

    @Override
    public float max() {
        return this.value1;
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return this.value1;
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public float[] toSortedArray() {
        return new float[]{this.value1};
    }

    @Override
    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.value1);
    }

    @Override
    public float[] toArray() {
        return new float[]{this.value1};
    }

    @Override
    public boolean contains(float value) {
        return Float.compare(this.value1, value) == 0;
    }

    @Override
    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.value1, value) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (Float.compare(this.value1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.value1);
    }

    @Override
    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter(this);
    }

    @Override
    public ImmutableObjectFloatMap<K> newWithKeyValue(K key, float value) {
        return ObjectFloatMaps.immutable.withAll(ObjectFloatHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableObjectFloatMap<K> newWithoutKey(K key) {
        return ImmutableObjectFloatSingletonMap.nullSafeEquals(this.key1, key) ? ImmutableObjectFloatEmptyMap.INSTANCE : this;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    @Override
    public ImmutableObjectFloatMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectFloatHashMap<K> map = new ObjectFloatHashMap<K>(this);
        for (K key : keys) {
            map.removeKey(key);
        }
        return map.toImmutable();
    }

    @Override
    public float get(Object key) {
        return this.getIfAbsent(key, 0.0f);
    }

    @Override
    public float getOrThrow(Object key) {
        if (ImmutableObjectFloatSingletonMap.nullSafeEquals(this.key1, key)) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public float getIfAbsent(Object key, float ifAbsent) {
        return ImmutableObjectFloatSingletonMap.nullSafeEquals(this.key1, key) ? this.value1 : ifAbsent;
    }

    @Override
    public boolean containsKey(Object key) {
        return ImmutableObjectFloatSingletonMap.nullSafeEquals(this.key1, key);
    }

    @Override
    public boolean containsValue(float value) {
        return Float.compare(this.value1, value) == 0;
    }

    @Override
    public void forEachValue(FloatProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(ObjectFloatProcedure<? super K> objectFloatProcedure) {
        objectFloatProcedure.value(this.key1, this.value1);
    }

    @Override
    public ImmutableObjectFloatMap<K> select(ObjectFloatPredicate<? super K> objectFloatPredicate) {
        return objectFloatPredicate.accept(this.key1, this.value1) ? ObjectFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : ImmutableObjectFloatEmptyMap.INSTANCE;
    }

    @Override
    public ImmutableObjectFloatMap<K> reject(ObjectFloatPredicate<? super K> objectFloatPredicate) {
        return objectFloatPredicate.accept(this.key1, this.value1) ? ImmutableObjectFloatEmptyMap.INSTANCE : ObjectFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public ImmutableObjectFloatMap<K> toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public Set<K> keySet() {
        return Sets.immutable.of(this.key1).castToSet();
    }

    @Override
    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(FloatArrayList.newListWith(this.value1));
    }

    @Override
    public LazyIterable<K> keysView() {
        return Lists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<ObjectFloatPair<K>> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectFloatMap)) {
            return false;
        }
        ObjectFloatMap map = (ObjectFloatMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && Float.compare(this.value1, map.getOrThrow(this.key1)) == 0;
    }

    public int hashCode() {
        return (this.key1 == null ? 0 : this.key1.hashCode()) ^ Float.floatToIntBits(this.value1);
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectFloatMap.ImmutableObjectFloatMapSerializationProxy(this);
    }
}

