/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectCharPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectCharProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.ImmutableObjectCharMap;
import com.gs.collections.api.map.primitive.MutableObjectCharMap;
import com.gs.collections.api.map.primitive.ObjectCharMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.tuple.primitive.ObjectCharPair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.iterator.UnmodifiableCharIterator;
import com.gs.collections.impl.map.immutable.primitive.AbstractImmutableObjectCharMap;
import com.gs.collections.impl.map.mutable.primitive.ObjectCharHashMap;
import com.gs.collections.impl.set.mutable.UnmodifiableMutableSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableObjectCharHashMap<K>
extends AbstractImmutableObjectCharMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectCharMap<K> delegate;

    ImmutableObjectCharHashMap(ObjectCharMap<? extends K> delegate) {
        this.delegate = new ObjectCharHashMap<K>(delegate);
    }

    @Override
    public CharIterator charIterator() {
        return new UnmodifiableCharIterator(this.delegate.charIterator());
    }

    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(CharProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(CharPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableCharCollection select(CharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableCharCollection reject(CharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public char max() {
        return this.delegate.max();
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public char min() {
        return this.delegate.min();
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public char[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableCharList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public char[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(char value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(char ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableCharList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableCharSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableCharBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyCharIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableObjectCharMap<K> newWithKeyValue(K key, char value) {
        ObjectCharHashMap<K> map = ObjectCharHashMap.newMap();
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableObjectCharMap<K> newWithoutKey(K key) {
        ObjectCharHashMap<K> map = ObjectCharHashMap.newMap();
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableObjectCharMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectCharHashMap<K> map = ObjectCharHashMap.newMap();
        map.putAll(this);
        Iterator<K> iterator = keys.iterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public char get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public char getOrThrow(Object key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public char getIfAbsent(Object key, char ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(char value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(CharProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ObjectCharProcedure<? super K> objectCharProcedure) {
        this.delegate.forEachKeyValue(objectCharProcedure);
    }

    @Override
    public ImmutableObjectCharMap<K> select(ObjectCharPredicate<? super K> objectCharPredicate) {
        return this.delegate.select(objectCharPredicate).toImmutable();
    }

    @Override
    public ImmutableObjectCharMap<K> reject(ObjectCharPredicate<? super K> objectCharPredicate) {
        return this.delegate.reject(objectCharPredicate).toImmutable();
    }

    @Override
    public ImmutableObjectCharMap<K> toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public Set<K> keySet() {
        return UnmodifiableMutableSet.of(this.delegate.keySet());
    }

    @Override
    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of(this.delegate.values());
    }

    @Override
    public LazyIterable<K> keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<ObjectCharPair<K>> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectCharMap.ImmutableObjectCharMapSerializationProxy(this);
    }
}

