/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectBytePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectByteProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.ImmutableObjectByteMap;
import com.gs.collections.api.map.primitive.MutableObjectByteMap;
import com.gs.collections.api.map.primitive.ObjectByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.tuple.primitive.ObjectBytePair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.iterator.UnmodifiableByteIterator;
import com.gs.collections.impl.map.immutable.primitive.AbstractImmutableObjectByteMap;
import com.gs.collections.impl.map.mutable.primitive.ObjectByteHashMap;
import com.gs.collections.impl.set.mutable.UnmodifiableMutableSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableObjectByteHashMap<K>
extends AbstractImmutableObjectByteMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectByteMap<K> delegate;

    ImmutableObjectByteHashMap(ObjectByteMap<? extends K> delegate) {
        this.delegate = new ObjectByteHashMap<K>(delegate);
    }

    @Override
    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator(this.delegate.byteIterator());
    }

    @Override
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ByteProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(BytePredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableByteCollection select(BytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableByteCollection reject(BytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public byte max() {
        return this.delegate.max();
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public byte min() {
        return this.delegate.min();
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public byte[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableByteList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public byte[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(byte value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(byte ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableByteList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableByteSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableByteBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyByteIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableObjectByteMap<K> newWithKeyValue(K key, byte value) {
        ObjectByteHashMap<K> map = ObjectByteHashMap.newMap();
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableObjectByteMap<K> newWithoutKey(K key) {
        ObjectByteHashMap<K> map = ObjectByteHashMap.newMap();
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableObjectByteMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectByteHashMap<K> map = ObjectByteHashMap.newMap();
        map.putAll(this);
        Iterator<K> iterator = keys.iterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public byte get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public byte getOrThrow(Object key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public byte getIfAbsent(Object key, byte ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(byte value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(ByteProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ObjectByteProcedure<? super K> objectByteProcedure) {
        this.delegate.forEachKeyValue(objectByteProcedure);
    }

    @Override
    public ImmutableObjectByteMap<K> select(ObjectBytePredicate<? super K> objectBytePredicate) {
        return this.delegate.select(objectBytePredicate).toImmutable();
    }

    @Override
    public ImmutableObjectByteMap<K> reject(ObjectBytePredicate<? super K> objectBytePredicate) {
        return this.delegate.reject(objectBytePredicate).toImmutable();
    }

    @Override
    public ImmutableObjectByteMap<K> toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public Set<K> keySet() {
        return UnmodifiableMutableSet.of(this.delegate.keySet());
    }

    @Override
    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(this.delegate.values());
    }

    @Override
    public LazyIterable<K> keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<ObjectBytePair<K>> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectByteMap.ImmutableObjectByteMapSerializationProxy(this);
    }
}

