/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.LongDoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.LongDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.ImmutableLongDoubleMap;
import com.gs.collections.api.map.primitive.LongDoubleMap;
import com.gs.collections.api.map.primitive.MutableLongDoubleMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.LongDoublePair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedLongDoubleProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.gs.collections.impl.iterator.UnmodifiableDoubleIterator;
import com.gs.collections.impl.map.mutable.primitive.LongDoubleHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableLongDoubleHashMap
implements ImmutableLongDoubleMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongDoubleMap delegate;

    ImmutableLongDoubleHashMap(LongDoubleMap delegate) {
        this.delegate = new LongDoubleHashMap(delegate);
    }

    @Override
    public double get(long key) {
        return this.delegate.get(key);
    }

    @Override
    public double getIfAbsent(long key, double ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public double getOrThrow(long key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(double value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(DoubleProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(LongProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(LongDoubleProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyLongIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<LongDoublePair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableLongDoubleMap select(LongDoublePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableLongDoubleMap reject(LongDoublePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableLongDoubleMap toImmutable() {
        return this;
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator(this.delegate.doubleIterator());
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(DoublePredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableDoubleCollection select(DoublePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableDoubleCollection reject(DoublePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public double sum() {
        return this.delegate.sum();
    }

    @Override
    public double max() {
        return this.delegate.max();
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public double min() {
        return this.delegate.min();
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public double[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableDoubleList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public double[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(double value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(double ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableDoubleList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableDoubleSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableDoubleBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableLongDoubleMap newWithKeyValue(long key, double value) {
        LongDoubleHashMap map = new LongDoubleHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableLongDoubleMap newWithoutKey(long key) {
        LongDoubleHashMap map = new LongDoubleHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableLongDoubleMap newWithoutAllKeys(LongIterable keys) {
        LongDoubleHashMap map = new LongDoubleHashMap(this.size());
        map.putAll(this);
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(this.delegate.keySet());
    }

    @Override
    public MutableDoubleCollection values() {
        return UnmodifiableDoubleCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableLongDoubleMapSerializationProxy(this);
    }

    protected static class ImmutableLongDoubleMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private LongDoubleMap map;

        public ImmutableLongDoubleMapSerializationProxy() {
        }

        protected ImmutableLongDoubleMapSerializationProxy(LongDoubleMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedLongDoubleProcedure(){

                    public void safeValue(long key, double value) throws IOException {
                        out.writeLong(key);
                        out.writeDouble(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            LongDoubleHashMap deserializedMap = new LongDoubleHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readLong(), in.readDouble());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

