/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.IntBytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.IntByteProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.ImmutableIntByteMap;
import com.gs.collections.api.map.primitive.IntByteMap;
import com.gs.collections.api.map.primitive.MutableIntByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.IntBytePair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedIntByteProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.iterator.UnmodifiableByteIterator;
import com.gs.collections.impl.map.mutable.primitive.IntByteHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableIntByteHashMap
implements ImmutableIntByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntByteMap delegate;

    ImmutableIntByteHashMap(IntByteMap delegate) {
        this.delegate = new IntByteHashMap(delegate);
    }

    @Override
    public byte get(int key) {
        return this.delegate.get(key);
    }

    @Override
    public byte getIfAbsent(int key, byte ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public byte getOrThrow(int key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(byte value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(ByteProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(IntByteProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyIntIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<IntBytePair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableIntByteMap select(IntBytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableIntByteMap reject(IntBytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableIntByteMap toImmutable() {
        return this;
    }

    @Override
    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator(this.delegate.byteIterator());
    }

    @Override
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ByteProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(BytePredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableByteCollection select(BytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableByteCollection reject(BytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public byte max() {
        return this.delegate.max();
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public byte min() {
        return this.delegate.min();
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public byte[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableByteList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public byte[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(byte value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(byte ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableByteList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableByteSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableByteBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyByteIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableIntByteMap newWithKeyValue(int key, byte value) {
        IntByteHashMap map = new IntByteHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableIntByteMap newWithoutKey(int key) {
        IntByteHashMap map = new IntByteHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableIntByteMap newWithoutAllKeys(IntIterable keys) {
        IntByteHashMap map = new IntByteHashMap(this.size());
        map.putAll(this);
        IntIterator iterator = keys.intIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(this.delegate.keySet());
    }

    @Override
    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableIntByteMapSerializationProxy(this);
    }

    protected static class ImmutableIntByteMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntByteMap map;

        public ImmutableIntByteMapSerializationProxy() {
        }

        protected ImmutableIntByteMapSerializationProxy(IntByteMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedIntByteProcedure(){

                    public void safeValue(int key, byte value) throws IOException {
                        out.writeInt(key);
                        out.writeByte(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            IntByteHashMap deserializedMap = new IntByteHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readInt(), in.readByte());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

