/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatLongPredicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatLongProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.FloatLongMap;
import com.gs.collections.api.map.primitive.ImmutableFloatLongMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.FloatLongPair;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.factory.primitive.FloatLongMaps;
import com.gs.collections.impl.iterator.UnmodifiableLongIterator;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.FloatLongHashMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableFloatLongSingletonMap
implements ImmutableFloatLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_VALUE = 0L;
    private final float key1;
    private final long value1;

    ImmutableFloatLongSingletonMap(float key1, long value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public long get(float key) {
        return this.getIfAbsent(key, 0L);
    }

    @Override
    public long getIfAbsent(float key, long ifAbsent) {
        return Float.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    @Override
    public long getOrThrow(float key) {
        if (Float.compare(this.key1, key) == 0) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(float key) {
        return Float.compare(this.key1, key) == 0;
    }

    @Override
    public boolean containsValue(long value) {
        return this.value1 == value;
    }

    @Override
    public void forEachValue(LongProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(FloatProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(FloatLongProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public LazyFloatIterable keysView() {
        return FloatLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<FloatLongPair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableFloatLongMap select(FloatLongPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? FloatLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new FloatLongHashMap().toImmutable();
    }

    @Override
    public ImmutableFloatLongMap reject(FloatLongPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new FloatLongHashMap().toImmutable() : FloatLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public ImmutableFloatLongMap toImmutable() {
        return this;
    }

    @Override
    public LongIterator longIterator() {
        return new UnmodifiableLongIterator(FloatLongHashMap.newWithKeysValues(this.key1, this.value1).longIterator());
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(LongProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(LongPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public long sum() {
        return this.value1;
    }

    @Override
    public long min() {
        return this.value1;
    }

    @Override
    public long max() {
        return this.value1;
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        return this.value1;
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public long[] toSortedArray() {
        return new long[]{this.value1};
    }

    @Override
    public MutableLongList toSortedList() {
        return LongArrayList.newListWith(this.value1);
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableLongCollection select(LongPredicate predicate) {
        return predicate.accept(this.value1) ? LongArrayList.newListWith(this.value1).toImmutable() : new LongArrayList().toImmutable();
    }

    @Override
    public ImmutableLongCollection reject(LongPredicate predicate) {
        return predicate.accept(this.value1) ? new LongArrayList().toImmutable() : LongArrayList.newListWith(this.value1).toImmutable();
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public long[] toArray() {
        return new long[]{this.value1};
    }

    @Override
    public boolean contains(long value) {
        return this.value1 == value;
    }

    @Override
    public boolean containsAll(long ... source) {
        for (long value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(LongIterable source) {
        LongIterator iterator = source.longIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableLongList toList() {
        return LongArrayList.newListWith(this.value1);
    }

    @Override
    public MutableLongSet toSet() {
        return LongHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableLongBag toBag() {
        return LongHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public ImmutableFloatLongMap newWithKeyValue(float key, long value) {
        return FloatLongMaps.immutable.withAll(FloatLongHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableFloatLongMap newWithoutKey(float key) {
        return Float.compare(this.key1, key) == 0 ? FloatLongMaps.immutable.with() : this;
    }

    @Override
    public ImmutableFloatLongMap newWithoutAllKeys(FloatIterable keys) {
        return keys.contains(this.key1) ? FloatLongMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(FloatHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableLongCollection values() {
        return UnmodifiableLongCollection.of(LongArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatLongMap)) {
            return false;
        }
        FloatLongMap map = (FloatLongMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.key1) ^ (int)(this.value1 ^ this.value1 >>> 32);
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

