/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatCharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatCharProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.FloatCharMap;
import com.gs.collections.api.map.primitive.ImmutableFloatCharMap;
import com.gs.collections.api.map.primitive.MutableFloatCharMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.FloatCharPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedFloatCharProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.iterator.UnmodifiableCharIterator;
import com.gs.collections.impl.map.mutable.primitive.FloatCharHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableFloatCharHashMap
implements ImmutableFloatCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableFloatCharMap delegate;

    ImmutableFloatCharHashMap(FloatCharMap delegate) {
        this.delegate = new FloatCharHashMap(delegate);
    }

    @Override
    public char get(float key) {
        return this.delegate.get(key);
    }

    @Override
    public char getIfAbsent(float key, char ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public char getOrThrow(float key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(float key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(char value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(CharProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(FloatProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(FloatCharProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyFloatIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<FloatCharPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableFloatCharMap select(FloatCharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableFloatCharMap reject(FloatCharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableFloatCharMap toImmutable() {
        return this;
    }

    @Override
    public CharIterator charIterator() {
        return new UnmodifiableCharIterator(this.delegate.charIterator());
    }

    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(CharProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(CharPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableCharCollection select(CharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableCharCollection reject(CharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public char max() {
        return this.delegate.max();
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public char min() {
        return this.delegate.min();
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public char[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableCharList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public char[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(char value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(char ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableCharList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableCharSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableCharBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyCharIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableFloatCharMap newWithKeyValue(float key, char value) {
        FloatCharHashMap map = new FloatCharHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableFloatCharMap newWithoutKey(float key) {
        FloatCharHashMap map = new FloatCharHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableFloatCharMap newWithoutAllKeys(FloatIterable keys) {
        FloatCharHashMap map = new FloatCharHashMap(this.size());
        map.putAll(this);
        FloatIterator iterator = keys.floatIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(this.delegate.keySet());
    }

    @Override
    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableFloatCharMapSerializationProxy(this);
    }

    protected static class ImmutableFloatCharMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private FloatCharMap map;

        public ImmutableFloatCharMapSerializationProxy() {
        }

        protected ImmutableFloatCharMapSerializationProxy(FloatCharMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedFloatCharProcedure(){

                    public void safeValue(float key, char value) throws IOException {
                        out.writeFloat(key);
                        out.writeChar(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            FloatCharHashMap deserializedMap = new FloatCharHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readFloat(), in.readChar());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

