/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.FloatBytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatByteProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.FloatByteMap;
import com.gs.collections.api.map.primitive.ImmutableFloatByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.FloatBytePair;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.FloatByteMaps;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.iterator.UnmodifiableByteIterator;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.map.mutable.primitive.FloatByteHashMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableFloatByteSingletonMap
implements ImmutableFloatByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = 0;
    private final float key1;
    private final byte value1;

    ImmutableFloatByteSingletonMap(float key1, byte value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public byte get(float key) {
        return this.getIfAbsent(key, (byte)0);
    }

    @Override
    public byte getIfAbsent(float key, byte ifAbsent) {
        return Float.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    @Override
    public byte getOrThrow(float key) {
        if (Float.compare(this.key1, key) == 0) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(float key) {
        return Float.compare(this.key1, key) == 0;
    }

    @Override
    public boolean containsValue(byte value) {
        return this.value1 == value;
    }

    @Override
    public void forEachValue(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(FloatProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(FloatByteProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public LazyFloatIterable keysView() {
        return FloatLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<FloatBytePair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableFloatByteMap select(FloatBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? FloatByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new FloatByteHashMap().toImmutable();
    }

    @Override
    public ImmutableFloatByteMap reject(FloatBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new FloatByteHashMap().toImmutable() : FloatByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public ImmutableFloatByteMap toImmutable() {
        return this;
    }

    @Override
    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator(FloatByteHashMap.newWithKeysValues(this.key1, this.value1).byteIterator());
    }

    @Override
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(BytePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public long sum() {
        return this.value1;
    }

    @Override
    public byte min() {
        return this.value1;
    }

    @Override
    public byte max() {
        return this.value1;
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        return this.value1;
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public byte[] toSortedArray() {
        return new byte[]{this.value1};
    }

    @Override
    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.value1);
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableByteCollection select(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteArrayList.newListWith(this.value1).toImmutable() : new ByteArrayList().toImmutable();
    }

    @Override
    public ImmutableByteCollection reject(BytePredicate predicate) {
        return predicate.accept(this.value1) ? new ByteArrayList().toImmutable() : ByteArrayList.newListWith(this.value1).toImmutable();
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public byte[] toArray() {
        return new byte[]{this.value1};
    }

    @Override
    public boolean contains(byte value) {
        return this.value1 == value;
    }

    @Override
    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.value1);
    }

    @Override
    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    @Override
    public ImmutableFloatByteMap newWithKeyValue(float key, byte value) {
        return FloatByteMaps.immutable.withAll(FloatByteHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableFloatByteMap newWithoutKey(float key) {
        return Float.compare(this.key1, key) == 0 ? FloatByteMaps.immutable.with() : this;
    }

    @Override
    public ImmutableFloatByteMap newWithoutAllKeys(FloatIterable keys) {
        return keys.contains(this.key1) ? FloatByteMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(FloatHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(ByteArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatByteMap)) {
            return false;
        }
        FloatByteMap map = (FloatByteMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.key1) ^ this.value1;
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

