/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatBooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.FloatBooleanMap;
import com.gs.collections.api.map.primitive.ImmutableFloatBooleanMap;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.FloatBooleanPair;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.FloatBooleanMaps;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.iterator.UnmodifiableBooleanIterator;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.map.mutable.primitive.FloatBooleanHashMap;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableFloatBooleanSingletonMap
implements ImmutableFloatBooleanMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean EMPTY_VALUE = false;
    private final float key1;
    private final boolean value1;

    ImmutableFloatBooleanSingletonMap(float key1, boolean value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public boolean get(float key) {
        return this.getIfAbsent(key, false);
    }

    @Override
    public boolean getIfAbsent(float key, boolean ifAbsent) {
        return Float.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    @Override
    public boolean getOrThrow(float key) {
        if (Float.compare(this.key1, key) == 0) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(float key) {
        return Float.compare(this.key1, key) == 0;
    }

    @Override
    public boolean containsValue(boolean value) {
        return this.value1 == value;
    }

    @Override
    public void forEachValue(BooleanProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(FloatProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(FloatBooleanProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public LazyFloatIterable keysView() {
        return FloatLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<FloatBooleanPair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableFloatBooleanMap select(FloatBooleanPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? FloatBooleanHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new FloatBooleanHashMap().toImmutable();
    }

    @Override
    public ImmutableFloatBooleanMap reject(FloatBooleanPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new FloatBooleanHashMap().toImmutable() : FloatBooleanHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public ImmutableFloatBooleanMap toImmutable() {
        return this;
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator(FloatBooleanHashMap.newWithKeysValues(this.key1, this.value1).booleanIterator());
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableBooleanCollection select(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? BooleanArrayList.newListWith(this.value1).toImmutable() : new BooleanArrayList().toImmutable();
    }

    @Override
    public ImmutableBooleanCollection reject(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? new BooleanArrayList().toImmutable() : BooleanArrayList.newListWith(this.value1).toImmutable();
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public boolean[] toArray() {
        return new boolean[]{this.value1};
    }

    @Override
    public boolean contains(boolean value) {
        return this.value1 == value;
    }

    @Override
    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanArrayList.newListWith(this.value1);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    @Override
    public ImmutableFloatBooleanMap newWithKeyValue(float key, boolean value) {
        return FloatBooleanMaps.immutable.withAll(FloatBooleanHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableFloatBooleanMap newWithoutKey(float key) {
        return Float.compare(this.key1, key) == 0 ? FloatBooleanMaps.immutable.with() : this;
    }

    @Override
    public ImmutableFloatBooleanMap newWithoutAllKeys(FloatIterable keys) {
        return keys.contains(this.key1) ? FloatBooleanMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(FloatHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableBooleanCollection values() {
        return UnmodifiableBooleanCollection.of(BooleanArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatBooleanMap)) {
            return false;
        }
        FloatBooleanMap map = (FloatBooleanMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.key1) ^ (this.value1 ? 1231 : 1237);
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

