/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleIntPredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.DoubleIntMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleIntMap;
import com.gs.collections.api.map.primitive.MutableDoubleIntMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.DoubleIntPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedDoubleIntProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.iterator.UnmodifiableIntIterator;
import com.gs.collections.impl.map.mutable.primitive.DoubleIntHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableDoubleIntHashMap
implements ImmutableDoubleIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleIntMap delegate;

    ImmutableDoubleIntHashMap(DoubleIntMap delegate) {
        this.delegate = new DoubleIntHashMap(delegate);
    }

    @Override
    public int get(double key) {
        return this.delegate.get(key);
    }

    @Override
    public int getIfAbsent(double key, int ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public int getOrThrow(double key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(double key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(int value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(IntProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(DoubleProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(DoubleIntProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyDoubleIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<DoubleIntPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableDoubleIntMap select(DoubleIntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableDoubleIntMap reject(DoubleIntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableDoubleIntMap toImmutable() {
        return this;
    }

    @Override
    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(this.delegate.intIterator());
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(IntPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableIntCollection select(IntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableIntCollection reject(IntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public int max() {
        return this.delegate.max();
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public int min() {
        return this.delegate.min();
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableIntList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public int[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(int value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(int ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(IntIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableIntList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableIntSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableIntBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyIntIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableDoubleIntMap newWithKeyValue(double key, int value) {
        DoubleIntHashMap map = new DoubleIntHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableDoubleIntMap newWithoutKey(double key) {
        DoubleIntHashMap map = new DoubleIntHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableDoubleIntMap newWithoutAllKeys(DoubleIterable keys) {
        DoubleIntHashMap map = new DoubleIntHashMap(this.size());
        map.putAll(this);
        DoubleIterator iterator = keys.doubleIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableDoubleSet keySet() {
        return UnmodifiableDoubleSet.of(this.delegate.keySet());
    }

    @Override
    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableDoubleIntMapSerializationProxy(this);
    }

    protected static class ImmutableDoubleIntMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private DoubleIntMap map;

        public ImmutableDoubleIntMapSerializationProxy() {
        }

        protected ImmutableDoubleIntMapSerializationProxy(DoubleIntMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedDoubleIntProcedure(){

                    public void safeValue(double key, int value) throws IOException {
                        out.writeDouble(key);
                        out.writeInt(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            DoubleIntHashMap deserializedMap = new DoubleIntHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readDouble(), in.readInt());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

