/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleDoublePredicate;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.DoubleDoubleMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleDoubleMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.tuple.primitive.DoubleDoublePair;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.DoubleDoubleMaps;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.iterator.UnmodifiableDoubleIterator;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.map.mutable.primitive.DoubleDoubleHashMap;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableDoubleDoubleSingletonMap
implements ImmutableDoubleDoubleMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_VALUE = 0.0;
    private final double key1;
    private final double value1;

    ImmutableDoubleDoubleSingletonMap(double key1, double value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public double get(double key) {
        return this.getIfAbsent(key, 0.0);
    }

    @Override
    public double getIfAbsent(double key, double ifAbsent) {
        return Double.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    @Override
    public double getOrThrow(double key) {
        if (Double.compare(this.key1, key) == 0) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(double key) {
        return Double.compare(this.key1, key) == 0;
    }

    @Override
    public boolean containsValue(double value) {
        return Double.compare(this.value1, value) == 0;
    }

    @Override
    public void forEachValue(DoubleProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(DoubleProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(DoubleDoubleProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public LazyDoubleIterable keysView() {
        return DoubleLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<DoubleDoublePair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableDoubleDoubleMap select(DoubleDoublePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? DoubleDoubleHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new DoubleDoubleHashMap().toImmutable();
    }

    @Override
    public ImmutableDoubleDoubleMap reject(DoubleDoublePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new DoubleDoubleHashMap().toImmutable() : DoubleDoubleHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public ImmutableDoubleDoubleMap toImmutable() {
        return this;
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator(DoubleDoubleHashMap.newWithKeysValues(this.key1, this.value1).doubleIterator());
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(DoublePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public double sum() {
        return this.value1;
    }

    @Override
    public double min() {
        return this.value1;
    }

    @Override
    public double max() {
        return this.value1;
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        return this.value1;
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public double[] toSortedArray() {
        return new double[]{this.value1};
    }

    @Override
    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newListWith(this.value1);
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableDoubleCollection select(DoublePredicate predicate) {
        return predicate.accept(this.value1) ? DoubleArrayList.newListWith(this.value1).toImmutable() : new DoubleArrayList().toImmutable();
    }

    @Override
    public ImmutableDoubleCollection reject(DoublePredicate predicate) {
        return predicate.accept(this.value1) ? new DoubleArrayList().toImmutable() : DoubleArrayList.newListWith(this.value1).toImmutable();
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public double[] toArray() {
        return new double[]{this.value1};
    }

    @Override
    public boolean contains(double value) {
        return Double.compare(this.value1, value) == 0;
    }

    @Override
    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (Double.compare(this.value1, value) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (Double.compare(this.value1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableDoubleList toList() {
        return DoubleArrayList.newListWith(this.value1);
    }

    @Override
    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public ImmutableDoubleDoubleMap newWithKeyValue(double key, double value) {
        return DoubleDoubleMaps.immutable.withAll(DoubleDoubleHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableDoubleDoubleMap newWithoutKey(double key) {
        return Double.compare(this.key1, key) == 0 ? DoubleDoubleMaps.immutable.with() : this;
    }

    @Override
    public ImmutableDoubleDoubleMap newWithoutAllKeys(DoubleIterable keys) {
        return keys.contains(this.key1) ? DoubleDoubleMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableDoubleSet keySet() {
        return UnmodifiableDoubleSet.of(DoubleHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableDoubleCollection values() {
        return UnmodifiableDoubleCollection.of(DoubleArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleDoubleMap)) {
            return false;
        }
        DoubleDoubleMap map = (DoubleDoubleMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && Double.compare(this.value1, map.getOrThrow(this.key1)) == 0;
    }

    @Override
    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.key1) ^ Double.doubleToLongBits(this.key1) >>> 32) ^ (int)(Double.doubleToLongBits(this.value1) ^ Double.doubleToLongBits(this.value1) >>> 32);
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

