/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.DoubleBytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleByteProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.DoubleByteMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.tuple.primitive.DoubleBytePair;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.DoubleByteMaps;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.iterator.UnmodifiableByteIterator;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.map.mutable.primitive.DoubleByteHashMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableDoubleByteSingletonMap
implements ImmutableDoubleByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = 0;
    private final double key1;
    private final byte value1;

    ImmutableDoubleByteSingletonMap(double key1, byte value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public byte get(double key) {
        return this.getIfAbsent(key, (byte)0);
    }

    @Override
    public byte getIfAbsent(double key, byte ifAbsent) {
        return Double.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    @Override
    public byte getOrThrow(double key) {
        if (Double.compare(this.key1, key) == 0) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(double key) {
        return Double.compare(this.key1, key) == 0;
    }

    @Override
    public boolean containsValue(byte value) {
        return this.value1 == value;
    }

    @Override
    public void forEachValue(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(DoubleProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(DoubleByteProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public LazyDoubleIterable keysView() {
        return DoubleLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<DoubleBytePair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableDoubleByteMap select(DoubleBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? DoubleByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new DoubleByteHashMap().toImmutable();
    }

    @Override
    public ImmutableDoubleByteMap reject(DoubleBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new DoubleByteHashMap().toImmutable() : DoubleByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public ImmutableDoubleByteMap toImmutable() {
        return this;
    }

    @Override
    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator(DoubleByteHashMap.newWithKeysValues(this.key1, this.value1).byteIterator());
    }

    @Override
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(BytePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public long sum() {
        return this.value1;
    }

    @Override
    public byte min() {
        return this.value1;
    }

    @Override
    public byte max() {
        return this.value1;
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        return this.value1;
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public byte[] toSortedArray() {
        return new byte[]{this.value1};
    }

    @Override
    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.value1);
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableByteCollection select(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteArrayList.newListWith(this.value1).toImmutable() : new ByteArrayList().toImmutable();
    }

    @Override
    public ImmutableByteCollection reject(BytePredicate predicate) {
        return predicate.accept(this.value1) ? new ByteArrayList().toImmutable() : ByteArrayList.newListWith(this.value1).toImmutable();
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public byte[] toArray() {
        return new byte[]{this.value1};
    }

    @Override
    public boolean contains(byte value) {
        return this.value1 == value;
    }

    @Override
    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.value1);
    }

    @Override
    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    @Override
    public ImmutableDoubleByteMap newWithKeyValue(double key, byte value) {
        return DoubleByteMaps.immutable.withAll(DoubleByteHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableDoubleByteMap newWithoutKey(double key) {
        return Double.compare(this.key1, key) == 0 ? DoubleByteMaps.immutable.with() : this;
    }

    @Override
    public ImmutableDoubleByteMap newWithoutAllKeys(DoubleIterable keys) {
        return keys.contains(this.key1) ? DoubleByteMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableDoubleSet keySet() {
        return UnmodifiableDoubleSet.of(DoubleHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(ByteArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleByteMap)) {
            return false;
        }
        DoubleByteMap map = (DoubleByteMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.key1) ^ Double.doubleToLongBits(this.key1) >>> 32) ^ this.value1;
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

