/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharIntPredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.CharIntProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.CharIntMap;
import com.gs.collections.api.map.primitive.ImmutableCharIntMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.CharIntPair;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.CharIntMaps;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.iterator.UnmodifiableIntIterator;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.map.mutable.primitive.CharIntHashMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableCharIntSingletonMap
implements ImmutableCharIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;
    private final char key1;
    private final int value1;

    ImmutableCharIntSingletonMap(char key1, int value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public int get(char key) {
        return this.getIfAbsent(key, 0);
    }

    @Override
    public int getIfAbsent(char key, int ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    @Override
    public int getOrThrow(char key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(char key) {
        return this.key1 == key;
    }

    @Override
    public boolean containsValue(int value) {
        return this.value1 == value;
    }

    @Override
    public void forEachValue(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(CharProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(CharIntProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public LazyCharIterable keysView() {
        return CharLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<CharIntPair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableCharIntMap select(CharIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? CharIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new CharIntHashMap().toImmutable();
    }

    @Override
    public ImmutableCharIntMap reject(CharIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new CharIntHashMap().toImmutable() : CharIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public ImmutableCharIntMap toImmutable() {
        return this;
    }

    @Override
    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(CharIntHashMap.newWithKeysValues(this.key1, this.value1).intIterator());
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(IntPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public long sum() {
        return this.value1;
    }

    @Override
    public int min() {
        return this.value1;
    }

    @Override
    public int max() {
        return this.value1;
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return this.value1;
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public int[] toSortedArray() {
        return new int[]{this.value1};
    }

    @Override
    public MutableIntList toSortedList() {
        return IntArrayList.newListWith(this.value1);
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableIntCollection select(IntPredicate predicate) {
        return predicate.accept(this.value1) ? IntArrayList.newListWith(this.value1).toImmutable() : new IntArrayList().toImmutable();
    }

    @Override
    public ImmutableIntCollection reject(IntPredicate predicate) {
        return predicate.accept(this.value1) ? new IntArrayList().toImmutable() : IntArrayList.newListWith(this.value1).toImmutable();
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public int[] toArray() {
        return new int[]{this.value1};
    }

    @Override
    public boolean contains(int value) {
        return this.value1 == value;
    }

    @Override
    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableIntList toList() {
        return IntArrayList.newListWith(this.value1);
    }

    @Override
    public MutableIntSet toSet() {
        return IntHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableIntBag toBag() {
        return IntHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public ImmutableCharIntMap newWithKeyValue(char key, int value) {
        return CharIntMaps.immutable.withAll(CharIntHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableCharIntMap newWithoutKey(char key) {
        return this.key1 == key ? CharIntMaps.immutable.with() : this;
    }

    @Override
    public ImmutableCharIntMap newWithoutAllKeys(CharIterable keys) {
        return keys.contains(this.key1) ? CharIntMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(CharHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(IntArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharIntMap)) {
            return false;
        }
        CharIntMap map = (CharIntMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

