/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ByteIntPredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.ByteIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ByteIntMap;
import com.gs.collections.api.map.primitive.ImmutableByteIntMap;
import com.gs.collections.api.map.primitive.MutableByteIntMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.ByteIntPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedByteIntProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.iterator.UnmodifiableIntIterator;
import com.gs.collections.impl.map.mutable.primitive.ByteIntHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableByteIntHashMap
implements ImmutableByteIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteIntMap delegate;

    ImmutableByteIntHashMap(ByteIntMap delegate) {
        this.delegate = new ByteIntHashMap(delegate);
    }

    @Override
    public int get(byte key) {
        return this.delegate.get(key);
    }

    @Override
    public int getIfAbsent(byte key, int ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public int getOrThrow(byte key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(byte key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(int value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(IntProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ByteIntProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyByteIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<ByteIntPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableByteIntMap select(ByteIntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableByteIntMap reject(ByteIntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableByteIntMap toImmutable() {
        return this;
    }

    @Override
    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(this.delegate.intIterator());
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(IntPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableIntCollection select(IntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableIntCollection reject(IntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public int max() {
        return this.delegate.max();
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public int min() {
        return this.delegate.min();
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableIntList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public int[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(int value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(int ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(IntIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableIntList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableIntSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableIntBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyIntIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableByteIntMap newWithKeyValue(byte key, int value) {
        ByteIntHashMap map = new ByteIntHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableByteIntMap newWithoutKey(byte key) {
        ByteIntHashMap map = new ByteIntHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableByteIntMap newWithoutAllKeys(ByteIterable keys) {
        ByteIntHashMap map = new ByteIntHashMap(this.size());
        map.putAll(this);
        ByteIterator iterator = keys.byteIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(this.delegate.keySet());
    }

    @Override
    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableByteIntMapSerializationProxy(this);
    }

    protected static class ImmutableByteIntMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ByteIntMap map;

        public ImmutableByteIntMapSerializationProxy() {
        }

        protected ImmutableByteIntMapSerializationProxy(ByteIntMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedByteIntProcedure(){

                    public void safeValue(byte key, int value) throws IOException {
                        out.writeByte(key);
                        out.writeInt(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ByteIntHashMap deserializedMap = new ByteIntHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readByte(), in.readInt());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

