/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.ByteBooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.ByteBooleanMap;
import com.gs.collections.api.map.primitive.ImmutableByteBooleanMap;
import com.gs.collections.api.map.primitive.MutableByteBooleanMap;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.tuple.primitive.ByteBooleanPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedByteBooleanProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import com.gs.collections.impl.iterator.UnmodifiableBooleanIterator;
import com.gs.collections.impl.map.mutable.primitive.ByteBooleanHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableByteBooleanHashMap
implements ImmutableByteBooleanMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteBooleanMap delegate;

    ImmutableByteBooleanHashMap(ByteBooleanMap delegate) {
        this.delegate = new ByteBooleanHashMap(delegate);
    }

    @Override
    public boolean get(byte key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean getIfAbsent(byte key, boolean ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public boolean getOrThrow(byte key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(byte key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(boolean value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(BooleanProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ByteBooleanProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyByteIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<ByteBooleanPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableByteBooleanMap select(ByteBooleanPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableByteBooleanMap reject(ByteBooleanPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableByteBooleanMap toImmutable() {
        return this;
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator(this.delegate.booleanIterator());
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableBooleanCollection select(BooleanPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableBooleanCollection reject(BooleanPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public boolean[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(boolean value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(boolean ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableBooleanList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableBooleanSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableBooleanBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableByteBooleanMap newWithKeyValue(byte key, boolean value) {
        ByteBooleanHashMap map = new ByteBooleanHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableByteBooleanMap newWithoutKey(byte key) {
        ByteBooleanHashMap map = new ByteBooleanHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableByteBooleanMap newWithoutAllKeys(ByteIterable keys) {
        ByteBooleanHashMap map = new ByteBooleanHashMap(this.size());
        map.putAll(this);
        ByteIterator iterator = keys.byteIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(this.delegate.keySet());
    }

    @Override
    public MutableBooleanCollection values() {
        return UnmodifiableBooleanCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableByteBooleanMapSerializationProxy(this);
    }

    protected static class ImmutableByteBooleanMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ByteBooleanMap map;

        public ImmutableByteBooleanMapSerializationProxy() {
        }

        protected ImmutableByteBooleanMapSerializationProxy(ByteBooleanMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedByteBooleanProcedure(){

                    public void safeValue(byte key, boolean value) throws IOException {
                        out.writeByte(key);
                        out.writeBoolean(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ByteBooleanHashMap deserializedMap = new ByteBooleanHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readByte(), in.readBoolean());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

