/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntIntProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.primitive.ImmutableIntList;
import com.gs.collections.api.list.primitive.IntList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.block.factory.primitive.IntPredicates;
import com.gs.collections.impl.lazy.primitive.CollectIntToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseIntIterable;
import com.gs.collections.impl.lazy.primitive.SelectIntIterable;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntInterval
implements ImmutableIntList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int from;
    private final int to;
    private final int step;

    private IntInterval(int from, int to, int step) {
        this.from = from;
        this.to = to;
        this.step = step;
    }

    public static IntInterval from(int newFrom) {
        return IntInterval.fromToBy(newFrom, newFrom, 1);
    }

    public IntInterval to(int newTo) {
        return IntInterval.fromToBy(this.from, newTo, this.step);
    }

    public IntInterval by(int newStep) {
        return IntInterval.fromToBy(this.from, this.to, newStep);
    }

    public static IntInterval zero() {
        return IntInterval.from(0);
    }

    public static IntInterval oneTo(int count) {
        return IntInterval.oneToBy(count, 1);
    }

    public static IntInterval oneToBy(int count, int step) {
        if (count < 1) {
            throw new IllegalArgumentException("Only positive ranges allowed using oneToBy");
        }
        return IntInterval.fromToBy(1, count, step);
    }

    public static IntInterval zeroTo(int count) {
        return IntInterval.zeroToBy(count, 1);
    }

    public static IntInterval zeroToBy(int count, int step) {
        return IntInterval.fromToBy(0, count, step);
    }

    public static IntInterval fromTo(int from, int to) {
        if (from <= to) {
            return IntInterval.fromToBy(from, to, 1);
        }
        return IntInterval.fromToBy(from, to, -1);
    }

    public static IntInterval evensFromTo(int from, int to) {
        if (from % 2 != 0) {
            from = from < to ? ++from : --from;
        }
        if (to % 2 != 0) {
            to = to > from ? --to : ++to;
        }
        return IntInterval.fromToBy(from, to, to > from ? 2 : -2);
    }

    public static IntInterval oddsFromTo(int from, int to) {
        if (from % 2 == 0) {
            from = from < to ? ++from : --from;
        }
        if (to % 2 == 0) {
            to = to > from ? --to : ++to;
        }
        return IntInterval.fromToBy(from, to, to > from ? 2 : -2);
    }

    public static IntInterval fromToBy(int from, int to, int stepBy) {
        if (stepBy == 0) {
            throw new IllegalArgumentException("Cannot use a step by of 0");
        }
        if (from > to && stepBy > 0 || from < to && stepBy < 0) {
            throw new IllegalArgumentException("Step by is incorrect for the range");
        }
        return new IntInterval(from, to, stepBy);
    }

    @Override
    public boolean containsAll(int ... values) {
        for (int value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsNone(int ... values) {
        for (int value : values) {
            if (!this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(int value) {
        return this.isWithinBoundaries(value) && (value - this.from) % this.step == 0;
    }

    private boolean isWithinBoundaries(int value) {
        return this.step > 0 && this.from <= value && value <= this.to || this.step < 0 && this.to <= value && value <= this.from;
    }

    @Override
    public void forEachWithIndex(IntIntProcedure procedure) {
        int index = 0;
        if (this.from <= this.to) {
            for (int i = this.from; i <= this.to; i += this.step) {
                procedure.value(i, index++);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                procedure.value(i, index++);
            }
        }
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        if (this.from <= this.to) {
            for (int i = this.from; i <= this.to; i += this.step) {
                procedure.value(i);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                procedure.value(i);
            }
        }
    }

    @Override
    public int count(IntPredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!predicate.accept(this.get(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        for (int i = 0; i < this.size(); ++i) {
            if (!predicate.accept(this.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        for (int i = 0; i < this.size(); ++i) {
            if (predicate.accept(this.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        for (int i = 0; i < this.size(); ++i) {
            if (!predicate.accept(this.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof IntList)) {
            return false;
        }
        IntList list = (IntList)otherList;
        if (this.size() != list.size()) {
            return false;
        }
        if (this.from <= this.to) {
            int listIndex = 0;
            for (int i = this.from; i <= this.to; i += this.step) {
                if (i == list.get(listIndex++)) continue;
                return false;
            }
        } else {
            int listIndex = 0;
            for (int i = this.from; i >= this.to; i += this.step) {
                if (i == list.get(listIndex++)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        if (this.from <= this.to) {
            for (int i = this.from; i <= this.to; i += this.step) {
                hashCode = 31 * hashCode + i;
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                hashCode = 31 * hashCode + i;
            }
        }
        return hashCode;
    }

    @Override
    public IntInterval toReversed() {
        return IntInterval.fromToBy(this.to, this.from, -this.step);
    }

    @Override
    public ImmutableIntList distinct() {
        return this;
    }

    @Override
    public ImmutableIntList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    @Override
    public int size() {
        return (this.to - this.from) / this.step + 1;
    }

    @Override
    public long dotProduct(IntList list) {
        if (this.size() != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum = 0L;
        for (int i = 0; i < this.size(); ++i) {
            sum += (long)this.get(i) * (long)list.get(i);
        }
        return sum;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean notEmpty() {
        return !this.isEmpty();
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                int value = this.get(i);
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int[] toArray() {
        final int[] result = new int[this.size()];
        this.forEachWithIndex(new IntIntProcedure(){

            public void value(int each, int index) {
                result[index] = each;
            }
        });
        return result;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        if (this.from <= this.to) {
            for (int i = this.from; i <= this.to; i += this.step) {
                result = function.valueOf(result, i);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                result = function.valueOf(result, i);
            }
        }
        return result;
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        int index = 0;
        if (this.from <= this.to) {
            for (int i = this.from; i <= this.to; i += this.step) {
                result = function.valueOf(result, i, index);
                ++index;
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                result = function.valueOf(result, i, index);
                ++index;
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public IntIterator intIterator() {
        return new IntIntervalIterator();
    }

    @Override
    public int getFirst() {
        return this.from;
    }

    @Override
    public int getLast() {
        return this.locationAfterN(this.size() - 1);
    }

    @Override
    public int get(int index) {
        this.checkBounds("index", index);
        return this.locationAfterN(index);
    }

    private void checkBounds(String name, int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(name + ": " + index + ' ' + this.toString());
        }
    }

    private int locationAfterN(int index) {
        if (index <= 0) {
            return this.from;
        }
        if (this.step > 0) {
            return (int)Math.min((long)this.from + (long)this.step * (long)index, (long)this.to);
        }
        return (int)Math.max((long)this.from + (long)this.step * (long)index, (long)this.to);
    }

    @Override
    public int indexOf(int value) {
        if (!this.isWithinBoundaries(value)) {
            return -1;
        }
        int diff = value - this.from;
        if (diff % this.step == 0) {
            return diff / this.step;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int value) {
        return this.indexOf(value);
    }

    @Override
    public ImmutableIntList select(IntPredicate predicate) {
        return IntArrayList.newList(new SelectIntIterable(this, predicate)).toImmutable();
    }

    @Override
    public ImmutableIntList reject(IntPredicate predicate) {
        return IntArrayList.newList(new SelectIntIterable(this, IntPredicates.not(predicate))).toImmutable();
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return new SelectIntIterable(this, predicate).detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableList<V> collect(IntToObjectFunction<? extends V> function) {
        return new CollectIntToObjectIterable<V>(this, function).toList().toImmutable();
    }

    @Override
    public LazyIntIterable asReversed() {
        return ReverseIntIterable.adapt(this);
    }

    @Override
    public long sum() {
        long sum = 0L;
        IntIterator intIterator = this.intIterator();
        while (intIterator.hasNext()) {
            sum += (long)intIterator.next();
        }
        return sum;
    }

    @Override
    public int max() {
        if (this.from >= this.to) {
            return this.getFirst();
        }
        return this.getLast();
    }

    @Override
    public int min() {
        if (this.from <= this.to) {
            return this.getFirst();
        }
        return this.getLast();
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return this.min();
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return this.max();
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public int binarySearch(int value) {
        if (this.step > 0 && this.from > value || this.step < 0 && this.from < value) {
            return -1;
        }
        if (this.step > 0 && this.to < value || this.step < 0 && this.to > value) {
            return -1 - this.size();
        }
        int diff = value - this.from;
        int index = diff / this.step;
        return diff % this.step == 0 ? index : (index + 2) * -1;
    }

    @Override
    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableIntList toList() {
        return IntArrayList.newList(this);
    }

    @Override
    public MutableIntList toSortedList() {
        return IntArrayList.newList(this).sortThis();
    }

    @Override
    public MutableIntSet toSet() {
        return IntHashSet.newSet(this);
    }

    @Override
    public MutableIntBag toBag() {
        return IntHashBag.newBag(this);
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public ImmutableIntList toImmutable() {
        return this;
    }

    @Override
    public ImmutableIntList newWith(int element) {
        return IntArrayList.newList(this).with(element).toImmutable();
    }

    @Override
    public ImmutableIntList newWithout(int element) {
        return IntArrayList.newList(this).without(element).toImmutable();
    }

    @Override
    public ImmutableIntList newWithAll(IntIterable elements) {
        return IntArrayList.newList(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableIntList newWithoutAll(IntIterable elements) {
        return IntArrayList.newList(this).withoutAll(elements).toImmutable();
    }

    private class IntIntervalIterator
    implements IntIterator {
        private int current;

        private IntIntervalIterator() {
            this.current = IntInterval.this.from;
        }

        public boolean hasNext() {
            if (IntInterval.this.from <= IntInterval.this.to) {
                return this.current <= IntInterval.this.to;
            }
            return this.current >= IntInterval.this.to;
        }

        public int next() {
            if (this.hasNext()) {
                int result = this.current;
                this.current += IntInterval.this.step;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

