/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ObjectShortIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.MutableShortIterator;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.ImmutableShortList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.primitive.ReverseShortIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.SynchronizedShortList;
import com.gs.collections.impl.list.mutable.primitive.UnmodifiableShortList;
import com.gs.collections.impl.primitive.AbstractShortIterable;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class ShortArrayList
extends AbstractShortIterable
implements MutableShortList,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final short[] DEFAULT_SIZED_EMPTY_ARRAY = new short[0];
    private static final short[] ZERO_SIZED_ARRAY = new short[0];
    private static final int MAXIMUM_ARRAY_SIZE = 0x7FFFFFF7;
    protected int size;
    protected transient short[] items = DEFAULT_SIZED_EMPTY_ARRAY;

    public ShortArrayList() {
    }

    public ShortArrayList(int initialCapacity) {
        this.items = initialCapacity == 0 ? ZERO_SIZED_ARRAY : new short[initialCapacity];
    }

    public ShortArrayList(short ... array) {
        this.size = array.length;
        this.items = array;
    }

    public static ShortArrayList newListWith(short ... elements) {
        return new ShortArrayList(elements);
    }

    public static ShortArrayList newList(ShortIterable source) {
        return ShortArrayList.newListWith(source.toArray());
    }

    public static ShortArrayList newWithNValues(int size, short value) {
        ShortArrayList newList = new ShortArrayList(size);
        for (int i = 0; i < size; ++i) {
            newList.add(value);
        }
        return newList;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.items, (short)0);
        this.size = 0;
    }

    @Override
    public boolean contains(short value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public short get(int index) {
        if (index < this.size) {
            return this.items[index];
        }
        throw this.newIndexOutOfBoundsException(index);
    }

    private IndexOutOfBoundsException newIndexOutOfBoundsException(int index) {
        return new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size);
    }

    @Override
    public short getFirst() {
        this.checkEmpty();
        return this.items[0];
    }

    @Override
    public short getLast() {
        this.checkEmpty();
        return this.items[this.size() - 1];
    }

    private void checkEmpty() {
        if (this.isEmpty()) {
            throw this.newIndexOutOfBoundsException(0);
        }
    }

    @Override
    public int indexOf(short value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(short value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void trimToSize() {
        if (this.size < this.items.length) {
            this.transferItemsToNewArrayWithCapacity(this.size);
        }
    }

    private void transferItemsToNewArrayWithCapacity(int newCapacity) {
        this.items = this.copyItemsWithNewCapacity(newCapacity);
    }

    private short[] copyItemsWithNewCapacity(int newCapacity) {
        short[] newItems = new short[newCapacity];
        System.arraycopy(this.items, 0, newItems, 0, Math.min(this.size, newCapacity));
        return newItems;
    }

    private int sizePlusFiftyPercent(int oldSize) {
        int result = oldSize + (oldSize >> 1) + 1;
        return result < oldSize ? 0x7FFFFFF7 : result;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.items.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = Math.max(this.sizePlusFiftyPercent(oldCapacity), minCapacity);
            this.transferItemsToNewArrayWithCapacity(newCapacity);
        }
    }

    private void ensureCapacityForAdd() {
        if (this.items == DEFAULT_SIZED_EMPTY_ARRAY) {
            this.items = new short[10];
        } else {
            this.transferItemsToNewArrayWithCapacity(this.sizePlusFiftyPercent(this.size));
        }
    }

    @Override
    public boolean add(short newItem) {
        if (this.items.length == this.size) {
            this.ensureCapacityForAdd();
        }
        this.items[this.size] = newItem;
        ++this.size;
        return true;
    }

    @Override
    public boolean addAll(short ... source) {
        if (source.length < 1) {
            return false;
        }
        this.copyItems(source.length, source);
        return true;
    }

    @Override
    public boolean addAll(ShortIterable source) {
        if (source instanceof ShortArrayList) {
            if (source.isEmpty()) {
                return false;
            }
            ShortArrayList other = (ShortArrayList)source;
            this.copyItems(other.size(), other.items);
            return true;
        }
        return this.addAll(source.toArray());
    }

    private void copyItems(int sourceSize, short[] source) {
        int newSize = this.size + sourceSize;
        this.ensureCapacity(newSize);
        System.arraycopy(source, 0, this.items, this.size, sourceSize);
        this.size = newSize;
    }

    private void throwOutOfBounds(int index) {
        throw this.newIndexOutOfBoundsException(index);
    }

    @Override
    public void addAtIndex(int index, short element) {
        if (index > -1 && index < this.size) {
            this.addAtIndexLessThanSize(index, element);
        } else if (index == this.size) {
            this.add(element);
        } else {
            this.throwOutOfBounds(index);
        }
    }

    private void addAtIndexLessThanSize(int index, short element) {
        int oldSize;
        if (this.items.length == (oldSize = this.size++)) {
            short[] newItems = new short[this.sizePlusFiftyPercent(oldSize)];
            if (index > 0) {
                System.arraycopy(this.items, 0, newItems, 0, index);
            }
            System.arraycopy(this.items, index, newItems, index + 1, oldSize - index);
            this.items = newItems;
        } else {
            System.arraycopy(this.items, index, this.items, index + 1, oldSize - index);
        }
        this.items[index] = element;
    }

    @Override
    public boolean addAllAtIndex(int index, short ... source) {
        if (index > this.size || index < 0) {
            this.throwOutOfBounds(index);
        }
        if (source.length == 0) {
            return false;
        }
        int sourceSize = source.length;
        int newSize = this.size + sourceSize;
        this.ensureCapacity(newSize);
        this.shiftElementsAtIndex(index, sourceSize);
        System.arraycopy(source, 0, this.items, index, sourceSize);
        this.size = newSize;
        return true;
    }

    @Override
    public boolean addAllAtIndex(int index, ShortIterable source) {
        return this.addAllAtIndex(index, source.toArray());
    }

    private void shiftElementsAtIndex(int index, int sourceSize) {
        int numberToMove = this.size - index;
        if (numberToMove > 0) {
            System.arraycopy(this.items, index, this.items, index + sourceSize, numberToMove);
        }
    }

    @Override
    public boolean remove(short value) {
        int index = this.indexOf(value);
        if (index >= 0) {
            this.removeAtIndex(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(ShortIterable source) {
        boolean modified = false;
        for (int index = 0; index < this.size; ++index) {
            if (!source.contains(this.get(index))) continue;
            this.removeAtIndex(index);
            --index;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(short ... source) {
        ShortHashSet set = ShortHashSet.newSetWith(source);
        short[] newItems = new short[this.size];
        int count = 0;
        int oldSize = this.size;
        for (int index = 0; index < this.size; ++index) {
            if (set.contains(this.items[index])) continue;
            newItems[count] = this.items[index];
            ++count;
        }
        this.items = newItems;
        this.size = count;
        return oldSize != this.size;
    }

    @Override
    public boolean retainAll(ShortIterable source) {
        int oldSize = this.size();
        final ShortSet sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
        ShortArrayList retained = this.select(new ShortPredicate(){

            public boolean accept(short value) {
                return sourceSet.contains(value);
            }
        });
        this.size = retained.size;
        this.items = retained.items;
        return oldSize != this.size();
    }

    @Override
    public boolean retainAll(short ... source) {
        return this.retainAll(ShortHashSet.newSetWith(source));
    }

    @Override
    public short removeAtIndex(int index) {
        short previous = this.get(index);
        int totalOffset = this.size - index - 1;
        if (totalOffset > 0) {
            System.arraycopy(this.items, index + 1, this.items, index, totalOffset);
        }
        --this.size;
        this.items[this.size] = 0;
        return previous;
    }

    @Override
    public short set(int index, short element) {
        short previous = this.get(index);
        this.items[index] = element;
        return previous;
    }

    @Override
    public ShortArrayList with(short element) {
        this.add(element);
        return this;
    }

    @Override
    public ShortArrayList without(short element) {
        this.remove(element);
        return this;
    }

    @Override
    public ShortArrayList withAll(ShortIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    @Override
    public ShortArrayList withoutAll(ShortIterable elements) {
        this.removeAll(elements);
        return this;
    }

    public ShortArrayList with(short element1, short element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public ShortArrayList with(short element1, short element2, short element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public ShortArrayList with(short element1, short element2, short element3, short ... elements) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this.withArrayCopy(elements, 0, elements.length);
    }

    private ShortArrayList withArrayCopy(short[] elements, int begin, int length) {
        this.ensureCapacity(this.size + length);
        System.arraycopy(elements, begin, this.items, this.size, length);
        this.size += length;
        return this;
    }

    @Override
    public MutableShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ShortProcedure procedure) {
        for (int i = 0; i < this.size; ++i) {
            procedure.value(this.items[i]);
        }
    }

    @Override
    public void forEachWithIndex(ShortIntProcedure procedure) {
        for (int i = 0; i < this.size; ++i) {
            procedure.value(this.items[i], i);
        }
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        for (int i = 0; i < this.size; ++i) {
            result = function.valueOf(result, this.items[i]);
        }
        return result;
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectShortIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        for (int i = 0; i < this.size; ++i) {
            result = function.valueOf(result, this.items[i], i);
        }
        return result;
    }

    @Override
    public int count(ShortPredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.accept(this.items[i])) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.accept(this.items[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (predicate.accept(this.items[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.accept(this.items[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public ShortArrayList select(ShortPredicate predicate) {
        ShortArrayList result = new ShortArrayList();
        for (int i = 0; i < this.size; ++i) {
            short item = this.items[i];
            if (!predicate.accept(item)) continue;
            result.add(item);
        }
        return result;
    }

    @Override
    public ShortArrayList reject(ShortPredicate predicate) {
        ShortArrayList result = new ShortArrayList();
        for (int i = 0; i < this.size; ++i) {
            short item = this.items[i];
            if (predicate.accept(item)) continue;
            result.add(item);
        }
        return result;
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        for (int i = 0; i < this.size; ++i) {
            short item = this.items[i];
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    @Override
    public <V> MutableList<V> collect(ShortToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size);
        for (int i = 0; i < this.size; ++i) {
            target.add(function.valueOf(this.items[i]));
        }
        return target;
    }

    @Override
    public short max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        short max = this.items[0];
        for (int i = 1; i < this.size; ++i) {
            short value = this.items[i];
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    @Override
    public short min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        short min = this.items[0];
        for (int i = 1; i < this.size; ++i) {
            short value = this.items[i];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    @Override
    public long sum() {
        long result = 0L;
        for (int i = 0; i < this.size; ++i) {
            result += (long)this.items[i];
        }
        return result;
    }

    @Override
    public long dotProduct(ShortList list) {
        if (this.size != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum = 0L;
        for (int i = 0; i < this.size; ++i) {
            sum += (long)this.items[i] * (long)list.get(i);
        }
        return sum;
    }

    @Override
    public short[] toArray() {
        short[] newItems = new short[this.size];
        System.arraycopy(this.items, 0, newItems, 0, this.size);
        return newItems;
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof ShortList)) {
            return false;
        }
        ShortList list = (ShortList)otherList;
        if (this.size != list.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] == list.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            short item = this.items[i];
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.size; ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                short value = this.items[i];
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableShortList asUnmodifiable() {
        return new UnmodifiableShortList(this);
    }

    @Override
    public MutableShortList asSynchronized() {
        return new SynchronizedShortList(this);
    }

    @Override
    public ImmutableShortList toImmutable() {
        if (this.size == 0) {
            return ShortLists.immutable.empty();
        }
        if (this.size == 1) {
            return ShortLists.immutable.with(this.items[0]);
        }
        return ShortLists.immutable.with(this.toArray());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeShort(this.items[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.size = in.readInt();
        this.items = new short[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.items[i] = in.readShort();
        }
    }

    @Override
    public LazyShortIterable asReversed() {
        return ReverseShortIterable.adapt(this);
    }

    @Override
    public ShortArrayList reverseThis() {
        int endIndex = this.size - 1;
        for (int i = 0; i < this.size / 2; ++i) {
            short tempSwapValue = this.items[i];
            this.items[i] = this.items[endIndex - i];
            this.items[endIndex - i] = tempSwapValue;
        }
        return this;
    }

    @Override
    public ShortArrayList sortThis() {
        Arrays.sort(this.items, 0, this.size);
        return this;
    }

    @Override
    public ShortArrayList toReversed() {
        return ShortArrayList.newList(this.asReversed());
    }

    @Override
    public int binarySearch(short value) {
        return Arrays.binarySearch(this.items, 0, this.size, value);
    }

    @Override
    public MutableShortList distinct() {
        ShortArrayList target = new ShortArrayList();
        ShortHashSet seenSoFar = new ShortHashSet(this.size());
        for (int i = 0; i < this.size; ++i) {
            short each = this.items[i];
            if (!seenSoFar.add(each)) continue;
            target.add(each);
        }
        return target;
    }

    @Override
    public MutableShortList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    private class InternalShortIterator
    implements MutableShortIterator {
        private int currentIndex;
        private int lastIndex = -1;

        private InternalShortIterator() {
        }

        public boolean hasNext() {
            return this.currentIndex != ShortArrayList.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short next = ShortArrayList.this.items[this.currentIndex];
            this.lastIndex = this.currentIndex++;
            return next;
        }

        public void remove() {
            if (this.lastIndex == -1) {
                throw new IllegalStateException();
            }
            ShortArrayList.this.removeAtIndex(this.lastIndex);
            --this.currentIndex;
            this.lastIndex = -1;
        }
    }
}

