/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.mutable;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.block.HashingStrategy;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.ParallelListIterable;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.multimap.list.MutableListMultimap;
import com.gs.collections.api.ordered.OrderedIterable;
import com.gs.collections.api.partition.list.PartitionMutableList;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.collection.mutable.AbstractSynchronizedMutableCollection;
import com.gs.collections.impl.collection.mutable.SynchronizedCollectionSerializationProxy;
import com.gs.collections.impl.lazy.ReverseIterable;
import com.gs.collections.impl.lazy.parallel.list.SynchronizedParallelListIterable;
import com.gs.collections.impl.list.mutable.ListAdapter;
import com.gs.collections.impl.list.mutable.UnmodifiableMutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import net.jcip.annotations.GuardedBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedMutableList<T>
extends AbstractSynchronizedMutableCollection<T>
implements MutableList<T>,
Serializable {
    private static final long serialVersionUID = 2L;

    SynchronizedMutableList(MutableList<T> newCollection) {
        super(newCollection);
    }

    SynchronizedMutableList(MutableList<T> newCollection, Object newLock) {
        super(newCollection, newLock);
    }

    public static <E, L extends List<E>> SynchronizedMutableList<E> of(L list) {
        MutableList mutableList = list instanceof MutableList ? (MutableList)list : ListAdapter.adapt(list);
        return new SynchronizedMutableList(mutableList);
    }

    public static <E, L extends List<E>> SynchronizedMutableList<E> of(L list, Object lock) {
        MutableList mutableList = list instanceof MutableList ? (MutableList)list : ListAdapter.adapt(list);
        return new SynchronizedMutableList(mutableList, lock);
    }

    @Override
    @GuardedBy(value="getLock()")
    protected MutableList<T> getDelegate() {
        return (MutableList)super.getDelegate();
    }

    @Override
    public MutableList<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    public MutableList<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    public MutableList<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    public MutableList<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedMutableList.of(this.getDelegate().clone());
        }
    }

    protected Object writeReplace() {
        return new SynchronizedCollectionSerializationProxy(this.getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().addAll(index, collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, T element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getDelegate().remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> subList(int fromIndex, int toIndex) {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedMutableList.of(this.getDelegate().subList(fromIndex, toIndex), this.getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getDelegate().get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().lastIndexOf(o);
        }
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.getDelegate().listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.getDelegate().listIterator(index);
    }

    @Override
    public ParallelListIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return new SynchronizedParallelListIterable(this.getDelegate().asParallel(executorService, batchSize), this.getLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int binarySearch(T key, Comparator<? super T> comparator) {
        Object object = this.getLock();
        synchronized (object) {
            return Collections.binarySearch(this, key, comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int binarySearch(T key) {
        Object object = this.getLock();
        synchronized (object) {
            return Collections.binarySearch(this, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().indexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> distinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().distinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> distinct(HashingStrategy<? super T> hashingStrategy) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().distinct(hashingStrategy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().corresponds(other, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(int fromIndex, int toIndex, Procedure<? super T> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().forEach(fromIndex, toIndex, procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> takeWhile(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().takeWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().forEachWithIndex(fromIndex, toIndex, objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> dropWhile(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().dropWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionMutableList<T> partitionWhile(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().partitionWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int detectIndex(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().detectIndex(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int detectLastIndex(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().detectLastIndex(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> take(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().take(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> drop(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().drop(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reverseForEach(Procedure<? super T> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().reverseForEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> sortThis(Comparator<? super T> comparator) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThis(comparator);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> sortThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThis();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V extends Comparable<? super V>> MutableList<T> sortThisBy(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisBy(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> sortThisByInt(IntFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByInt(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> sortThisByBoolean(BooleanFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByBoolean(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> sortThisByChar(CharFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByChar(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> sortThisByByte(ByteFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByByte(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> sortThisByShort(ShortFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByShort(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> sortThisByFloat(FloatFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByFloat(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> sortThisByLong(LongFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByLong(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> sortThisByDouble(DoubleFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByDouble(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> reverseThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().reverseThis();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> shuffleThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().shuffleThis();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> shuffleThis(Random rnd) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().shuffleThis(rnd);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyIterable<T> asReversed() {
        Object object = this.getLock();
        synchronized (object) {
            return ReverseIterable.adapt(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> toReversed() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toReversed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableStack<T> toStack() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableList<T> toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> tap(Procedure<? super T> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.forEach(procedure);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> select(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> MutableList<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> reject(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> MutableList<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionMutableList<T> partition(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().partition(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> PartitionMutableList<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().partitionWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectInstancesOf(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectBoolean(booleanFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectByte(byteFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharList collectChar(CharFunction<? super T> charFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectChar(charFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectDouble(doubleFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectFloat(floatFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntList collectInt(IntFunction<? super T> intFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectInt(intFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableLongList collectLong(LongFunction<? super T> longFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectLong(longFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectShort(shortFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableList<V> collect(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P, V> MutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectWith(function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectIf(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().flatCollect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().groupBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().groupByEach(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> MutableList<Pair<T, S>> zip(Iterable<S> that) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().zip(that);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<Pair<T, Integer>> zipWithIndex() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().zipWithIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return UnmodifiableMutableList.of(this);
        }
    }

    @Override
    public MutableList<T> asSynchronized() {
        return this;
    }
}

