/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.list.immutable.AbstractImmutableList;
import java.io.Serializable;
import java.util.RandomAccess;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableDoubletonList<T>
extends AbstractImmutableList<T>
implements Serializable,
RandomAccess {
    private static final long serialVersionUID = 1L;
    private final T element1;
    private final T element2;

    ImmutableDoubletonList(T obj1, T obj2) {
        this.element1 = obj1;
        this.element2 = obj2;
    }

    @Override
    public T getFirst() {
        return this.element1;
    }

    @Override
    public T getLast() {
        return this.element2;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        procedure.value(this.element1);
        procedure.value(this.element2);
    }

    @Override
    public T get(int index) {
        switch (index) {
            case 0: {
                return this.element1;
            }
            case 1: {
                return this.element2;
            }
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    @Override
    public boolean contains(Object obj) {
        return Comparators.nullSafeEquals(obj, this.element1) || Comparators.nullSafeEquals(obj, this.element2);
    }

    @Override
    public ImmutableList<T> newWith(T newItem) {
        return Lists.immutable.with(this.element1, this.element2, newItem);
    }
}

