/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.fixed;

import com.gs.collections.api.factory.list.FixedSizeListFactory;
import com.gs.collections.api.list.FixedSizeList;
import com.gs.collections.impl.list.fixed.ArrayAdapter;
import com.gs.collections.impl.list.fixed.DoubletonList;
import com.gs.collections.impl.list.fixed.EmptyList;
import com.gs.collections.impl.list.fixed.QuadrupletonList;
import com.gs.collections.impl.list.fixed.QuintupletonList;
import com.gs.collections.impl.list.fixed.SextupletonList;
import com.gs.collections.impl.list.fixed.SingletonList;
import com.gs.collections.impl.list.fixed.TripletonList;
import com.gs.collections.impl.utility.Iterate;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class FixedSizeListFactoryImpl
implements FixedSizeListFactory {
    private static final FixedSizeList<?> EMPTY_LIST = new EmptyList();

    @Override
    public <T> FixedSizeList<T> empty() {
        return EMPTY_LIST;
    }

    @Override
    public <T> FixedSizeList<T> of() {
        return this.empty();
    }

    @Override
    public <T> FixedSizeList<T> with() {
        return this.empty();
    }

    @Override
    public <T> FixedSizeList<T> of(T one) {
        return this.with(one);
    }

    @Override
    public <T> FixedSizeList<T> with(T one) {
        return new SingletonList<T>(one);
    }

    @Override
    public <T> FixedSizeList<T> of(T one, T two) {
        return this.with(one, two);
    }

    @Override
    public <T> FixedSizeList<T> with(T one, T two) {
        return new DoubletonList<T>(one, two);
    }

    @Override
    public <T> FixedSizeList<T> of(T one, T two, T three) {
        return this.with(one, two, three);
    }

    @Override
    public <T> FixedSizeList<T> with(T one, T two, T three) {
        return new TripletonList<T>(one, two, three);
    }

    @Override
    public <T> FixedSizeList<T> of(T one, T two, T three, T four) {
        return this.with(one, two, three, four);
    }

    @Override
    public <T> FixedSizeList<T> with(T one, T two, T three, T four) {
        return new QuadrupletonList<T>(one, two, three, four);
    }

    @Override
    public <T> FixedSizeList<T> of(T one, T two, T three, T four, T five) {
        return this.with(one, two, three, four, five);
    }

    @Override
    public <T> FixedSizeList<T> with(T one, T two, T three, T four, T five) {
        return new QuintupletonList<T>(one, two, three, four, five);
    }

    @Override
    public <T> FixedSizeList<T> of(T one, T two, T three, T four, T five, T six) {
        return this.with(one, two, three, four, five, six);
    }

    @Override
    public <T> FixedSizeList<T> with(T one, T two, T three, T four, T five, T six) {
        return new SextupletonList<T>(one, two, three, four, five, six);
    }

    @Override
    public <T> FixedSizeList<T> of(T ... items) {
        return this.with(items);
    }

    @Override
    public <T> FixedSizeList<T> with(T ... items) {
        switch (items.length) {
            case 0: {
                return this.of();
            }
            case 1: {
                return this.of(items[0]);
            }
            case 2: {
                return this.of(items[0], items[1]);
            }
            case 3: {
                return this.of(items[0], items[1], items[2]);
            }
            case 4: {
                return this.of(items[0], items[1], items[2], items[3]);
            }
            case 5: {
                return this.of(items[0], items[1], items[2], items[3], items[4]);
            }
            case 6: {
                return this.of(items[0], items[1], items[2], items[3], items[4], items[5]);
            }
        }
        return ArrayAdapter.newArrayWith(items);
    }

    @Override
    public <T> FixedSizeList<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    @Override
    public <T> FixedSizeList<T> withAll(Iterable<? extends T> items) {
        return this.of(Iterate.toArray(items));
    }
}

