/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.fixed;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.list.fixed.AbstractMemoryEfficientMutableList;
import com.gs.collections.impl.list.fixed.TripletonList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
final class DoubletonList<T>
extends AbstractMemoryEfficientMutableList<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private T element1;
    private T element2;

    public DoubletonList() {
    }

    DoubletonList(T obj1, T obj2) {
        this.element1 = obj1;
        this.element2 = obj2;
    }

    @Override
    public TripletonList<T> with(T value) {
        return new TripletonList<T>(this.element1, this.element2, value);
    }

    @Override
    public DoubletonList<T> clone() {
        return new DoubletonList<T>(this.element1, this.element2);
    }

    @Override
    public T getFirst() {
        return this.element1;
    }

    @Override
    public T getLast() {
        return this.element2;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public T get(int index) {
        switch (index) {
            case 0: {
                return this.element1;
            }
            case 1: {
                return this.element2;
            }
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    @Override
    public boolean contains(Object obj) {
        return Comparators.nullSafeEquals(obj, this.element1) || Comparators.nullSafeEquals(obj, this.element2);
    }

    @Override
    public T set(int index, T element) {
        switch (index) {
            case 0: {
                T previousElement1 = this.element1;
                this.element1 = element;
                return previousElement1;
            }
            case 1: {
                T previousElement2 = this.element2;
                this.element2 = element;
                return previousElement2;
            }
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        procedure.value(this.element1);
        procedure.value(this.element2);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        objectIntProcedure.value(this.element1, 0);
        objectIntProcedure.value(this.element2, 1);
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        procedure.value(this.element1, parameter);
        procedure.value(this.element2, parameter);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.element1);
        out.writeObject(this.element2);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.element1 = in.readObject();
        this.element2 = in.readObject();
    }
}

