/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.block.factory.primitive.ShortPredicates;
import com.gs.collections.impl.lazy.primitive.AbstractLazyShortIterable;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import java.util.NoSuchElementException;

public class SelectShortIterable
extends AbstractLazyShortIterable {
    private final ShortIterable delegate;
    private final ShortPredicate predicate;

    public SelectShortIterable(ShortIterable delegate, ShortPredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public ShortIterator shortIterator() {
        return new SelectShortIterator(this.delegate, this.predicate);
    }

    public void each(ShortProcedure procedure) {
        this.delegate.forEach(new IfShortProcedure(procedure));
    }

    public int size() {
        return this.delegate.count(this.predicate);
    }

    public boolean isEmpty() {
        return !this.shortIterator().hasNext();
    }

    public boolean notEmpty() {
        return this.shortIterator().hasNext();
    }

    public int count(ShortPredicate predicate) {
        CountShortProcedure countShortProcedure = new CountShortProcedure(predicate);
        this.forEach(countShortProcedure);
        return countShortProcedure.getCount();
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return this.delegate.anySatisfy(ShortPredicates.and(this.predicate, predicate));
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return this.noneSatisfy(ShortPredicates.not(predicate));
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public short[] toArray() {
        final short[] array = new short[this.size()];
        this.forEach(new ShortProcedure(){
            private int index = 0;

            public void value(short each) {
                array[this.index++] = each;
            }
        });
        return array;
    }

    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableShortList toList() {
        return ShortArrayList.newList(this);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSet(this);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBag(this);
    }

    private static final class SelectShortIterator
    implements ShortIterator {
        private final ShortIterator iterator;
        private final ShortPredicate predicate;
        private short next;
        private boolean verifiedHasNext = false;

        private SelectShortIterator(ShortIterable iterable, ShortPredicate predicate) {
            this(iterable.shortIterator(), predicate);
        }

        private SelectShortIterator(ShortIterator iterator, ShortPredicate predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                short temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        public short next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfShortProcedure
    implements ShortProcedure {
        private static final long serialVersionUID = 1L;
        private final ShortProcedure procedure;

        private IfShortProcedure(ShortProcedure procedure) {
            this.procedure = procedure;
        }

        public void value(short each) {
            if (SelectShortIterable.this.predicate.accept(each)) {
                this.procedure.value(each);
            }
        }
    }

    private static final class CountShortProcedure
    implements ShortProcedure {
        private static final long serialVersionUID = 1L;
        private final ShortPredicate predicate;
        private int counter = 0;

        private CountShortProcedure(ShortPredicate predicate) {
            this.predicate = predicate;
        }

        public void value(short each) {
            if (this.predicate.accept(each)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

