/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.block.factory.primitive.FloatPredicates;
import com.gs.collections.impl.lazy.primitive.AbstractLazyFloatIterable;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import java.util.NoSuchElementException;

public class SelectFloatIterable
extends AbstractLazyFloatIterable {
    private final FloatIterable delegate;
    private final FloatPredicate predicate;

    public SelectFloatIterable(FloatIterable delegate, FloatPredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public FloatIterator floatIterator() {
        return new SelectFloatIterator(this.delegate, this.predicate);
    }

    public void each(FloatProcedure procedure) {
        this.delegate.forEach(new IfFloatProcedure(procedure));
    }

    public int size() {
        return this.delegate.count(this.predicate);
    }

    public boolean isEmpty() {
        return !this.floatIterator().hasNext();
    }

    public boolean notEmpty() {
        return this.floatIterator().hasNext();
    }

    public int count(FloatPredicate predicate) {
        CountFloatProcedure countFloatProcedure = new CountFloatProcedure(predicate);
        this.forEach(countFloatProcedure);
        return countFloatProcedure.getCount();
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.delegate.anySatisfy(FloatPredicates.and(this.predicate, predicate));
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.noneSatisfy(FloatPredicates.not(predicate));
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public float[] toArray() {
        final float[] array = new float[this.size()];
        this.forEach(new FloatProcedure(){
            private int index = 0;

            public void value(float each) {
                array[this.index++] = each;
            }
        });
        return array;
    }

    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableFloatList toList() {
        return FloatArrayList.newList(this);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSet(this);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBag(this);
    }

    private static final class SelectFloatIterator
    implements FloatIterator {
        private final FloatIterator iterator;
        private final FloatPredicate predicate;
        private float next;
        private boolean verifiedHasNext = false;

        private SelectFloatIterator(FloatIterable iterable, FloatPredicate predicate) {
            this(iterable.floatIterator(), predicate);
        }

        private SelectFloatIterator(FloatIterator iterator, FloatPredicate predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                float temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        public float next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfFloatProcedure
    implements FloatProcedure {
        private static final long serialVersionUID = 1L;
        private final FloatProcedure procedure;

        private IfFloatProcedure(FloatProcedure procedure) {
            this.procedure = procedure;
        }

        public void value(float each) {
            if (SelectFloatIterable.this.predicate.accept(each)) {
                this.procedure.value(each);
            }
        }
    }

    private static final class CountFloatProcedure
    implements FloatProcedure {
        private static final long serialVersionUID = 1L;
        private final FloatPredicate predicate;
        private int counter = 0;

        private CountFloatProcedure(FloatPredicate predicate) {
            this.predicate = predicate;
        }

        public void value(float each) {
            if (this.predicate.accept(each)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

