/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.FloatList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.lazy.primitive.AbstractLazyFloatIterable;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import java.util.NoSuchElementException;

public class ReverseFloatIterable
extends AbstractLazyFloatIterable {
    private final FloatList adapted;

    public ReverseFloatIterable(FloatList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseFloatIterable adapt(FloatList floatList) {
        return new ReverseFloatIterable(floatList);
    }

    public FloatIterator floatIterator() {
        return new ReverseFloatIterator();
    }

    public void each(FloatProcedure procedure) {
        FloatIterator iterator = this.floatIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public double sum() {
        return this.adapted.sum();
    }

    public float max() {
        return this.adapted.max();
    }

    public float min() {
        return this.adapted.min();
    }

    public float minIfEmpty(float defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public float maxIfEmpty(float defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average() {
        return this.adapted.average();
    }

    public double median() {
        return this.adapted.median();
    }

    public float[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    public float[] toArray() {
        float[] results = new float[this.adapted.size()];
        int index = 0;
        FloatIterator iterator = this.floatIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    public boolean contains(float value) {
        return this.adapted.contains(value);
    }

    public boolean containsAll(float ... source) {
        return this.adapted.containsAll(source);
    }

    public boolean containsAll(FloatIterable source) {
        return this.adapted.containsAll(source);
    }

    public int size() {
        return this.adapted.size();
    }

    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    public MutableFloatList toList() {
        return FloatArrayList.newList(this);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSet(this);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBag(this);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter(this);
    }

    private class ReverseFloatIterator
    implements FloatIterator {
        private int currentIndex;

        private ReverseFloatIterator() {
            this.currentIndex = ReverseFloatIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            float next = ReverseFloatIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

