/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.util.Arrays;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CollectDoubleIterable<T>
extends AbstractLazyDoubleIterable {
    private final LazyIterable<T> iterable;
    private final DoubleFunction<? super T> function;
    private final DoubleFunctionToProcedure<T> doubleFunctionToProcedure;

    public CollectDoubleIterable(LazyIterable<T> adapted, DoubleFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.doubleFunctionToProcedure = new DoubleFunctionToProcedure(function);
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new DoubleIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectDoubleIterable.this.iterable.iterator();
            }

            public double next() {
                return CollectDoubleIterable.this.function.doubleValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        this.iterable.forEachWith(this.doubleFunctionToProcedure, procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(final DoublePredicate predicate) {
        return this.iterable.count(new Predicate<T>(){

            @Override
            public boolean accept(T each) {
                return predicate.accept(CollectDoubleIterable.this.function.doubleValueOf(each));
            }
        });
    }

    @Override
    public boolean anySatisfy(final DoublePredicate predicate) {
        return this.iterable.anySatisfy(new Predicate<T>(){

            @Override
            public boolean accept(T each) {
                return predicate.accept(CollectDoubleIterable.this.function.doubleValueOf(each));
            }
        });
    }

    @Override
    public boolean allSatisfy(final DoublePredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            @Override
            public boolean accept(T each) {
                return predicate.accept(CollectDoubleIterable.this.function.doubleValueOf(each));
            }
        });
    }

    @Override
    public boolean noneSatisfy(final DoublePredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            @Override
            public boolean accept(T each) {
                return !predicate.accept(CollectDoubleIterable.this.function.doubleValueOf(each));
            }
        });
    }

    @Override
    public double[] toArray() {
        final double[] array = new double[this.size()];
        this.iterable.forEachWithIndex(new ObjectIntProcedure<T>(){

            @Override
            public void value(T each, int index) {
                array[index] = CollectDoubleIterable.this.function.doubleValueOf(each);
            }
        });
        return array;
    }

    @Override
    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableDoubleList toList() {
        return DoubleArrayList.newList(this);
    }

    @Override
    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet(this);
    }

    @Override
    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag(this);
    }

    @Override
    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DoubleFunctionToProcedure<T>
    implements Procedure2<T, DoubleProcedure> {
        private static final long serialVersionUID = 1L;
        private final DoubleFunction<? super T> function;

        private DoubleFunctionToProcedure(DoubleFunction<? super T> function) {
            this.function = function;
        }

        @Override
        public void value(T each, DoubleProcedure procedure) {
            procedure.value(this.function.doubleValueOf(each));
        }
    }
}

