/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToBooleanFunction;
import com.gs.collections.api.block.function.primitive.CharToByteFunction;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.function.primitive.CharToDoubleFunction;
import com.gs.collections.api.block.function.primitive.CharToFloatFunction;
import com.gs.collections.api.block.function.primitive.CharToIntFunction;
import com.gs.collections.api.block.function.primitive.CharToLongFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.CharToShortFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.block.factory.primitive.CharPredicates;
import com.gs.collections.impl.factory.primitive.CharSets;
import com.gs.collections.impl.lazy.primitive.CollectCharToBooleanIterable;
import com.gs.collections.impl.lazy.primitive.CollectCharToByteIterable;
import com.gs.collections.impl.lazy.primitive.CollectCharToCharIterable;
import com.gs.collections.impl.lazy.primitive.CollectCharToDoubleIterable;
import com.gs.collections.impl.lazy.primitive.CollectCharToFloatIterable;
import com.gs.collections.impl.lazy.primitive.CollectCharToIntIterable;
import com.gs.collections.impl.lazy.primitive.CollectCharToLongIterable;
import com.gs.collections.impl.lazy.primitive.CollectCharToShortIterable;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.utility.internal.primitive.CharIterableIterate;
import com.gs.collections.impl.utility.primitive.LazyCharIterate;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLazyCharIterable
implements LazyCharIterable {
    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public int size() {
        return this.count(CharPredicates.alwaysTrue());
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public boolean isEmpty() {
        return CharIterableIterate.isEmpty(this);
    }

    @Override
    public boolean notEmpty() {
        return CharIterableIterate.notEmpty(this);
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        CharIterableIterate.appendString(this, appendable, start, separator, end);
    }

    @Override
    public boolean contains(char value) {
        return this.anySatisfy(CharPredicates.equal(value));
    }

    @Override
    public boolean containsAll(char ... source) {
        return this.containsAll(CharSets.immutable.of(source));
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return source.allSatisfy(new CharPredicate(){

            public boolean accept(char value) {
                return AbstractLazyCharIterable.this.contains(value);
            }
        });
    }

    @Override
    public LazyCharIterable select(CharPredicate predicate) {
        return LazyCharIterate.select(this, predicate);
    }

    @Override
    public LazyCharIterable reject(CharPredicate predicate) {
        return LazyCharIterate.select(this, CharPredicates.not(predicate));
    }

    @Override
    public <V> LazyIterable<V> collect(CharToObjectFunction<? extends V> function) {
        return LazyCharIterate.collect(this, function);
    }

    @Override
    public LazyBooleanIterable collectBoolean(CharToBooleanFunction function) {
        return new CollectCharToBooleanIterable(this, function);
    }

    @Override
    public LazyByteIterable collectByte(CharToByteFunction function) {
        return new CollectCharToByteIterable(this, function);
    }

    @Override
    public LazyCharIterable collectChar(CharToCharFunction function) {
        return new CollectCharToCharIterable(this, function);
    }

    @Override
    public LazyShortIterable collectShort(CharToShortFunction function) {
        return new CollectCharToShortIterable(this, function);
    }

    @Override
    public LazyIntIterable collectInt(CharToIntFunction function) {
        return new CollectCharToIntIterable(this, function);
    }

    @Override
    public LazyFloatIterable collectFloat(CharToFloatFunction function) {
        return new CollectCharToFloatIterable(this, function);
    }

    @Override
    public LazyLongIterable collectLong(CharToLongFunction function) {
        return new CollectCharToLongIterable(this, function);
    }

    @Override
    public LazyDoubleIterable collectDouble(CharToDoubleFunction function) {
        return new CollectCharToDoubleIterable(this, function);
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return CharIterableIterate.detectIfNone(this, predicate, ifNone);
    }

    @Override
    public int count(CharPredicate predicate) {
        return CharIterableIterate.count(this, predicate);
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return CharIterableIterate.anySatisfy(this, predicate);
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return CharIterableIterate.allSatisfy(this, predicate);
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return CharIterableIterate.noneSatisfy(this, predicate);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return CharIterableIterate.injectInto(this, injectedValue, function);
    }

    @Override
    public char[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public MutableCharList toList() {
        final CharArrayList list = new CharArrayList();
        this.forEach(new CharProcedure(){

            public void value(char each) {
                list.add(each);
            }
        });
        return list;
    }

    @Override
    public MutableCharSet toSet() {
        final CharHashSet set = new CharHashSet();
        this.forEach(new CharProcedure(){

            public void value(char each) {
                set.add(each);
            }
        });
        return set;
    }

    @Override
    public MutableCharBag toBag() {
        final CharHashBag bag = new CharHashBag();
        this.forEach(new CharProcedure(){

            public void value(char each) {
                bag.add(each);
            }
        });
        return bag;
    }

    @Override
    public long sum() {
        CharSumProcedure procedure = new CharSumProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    @Override
    public char max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        CharMaxProcedure procedure = new CharMaxProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    @Override
    public char maxIfEmpty(char ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.max();
    }

    @Override
    public char min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        CharMinProcedure procedure = new CharMinProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    @Override
    public char minIfEmpty(char ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.min();
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        char[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            char first = sortedArray[middleIndex];
            char second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public char[] toSortedArray() {
        return this.toSortedList().toArray();
    }

    @Override
    public MutableCharList toSortedList() {
        return CharArrayList.newList(this).sortThis();
    }

    @Override
    public LazyCharIterable asLazy() {
        return this;
    }

    private static final class CharSumProcedure
    implements CharProcedure {
        private char sum = '\u0000';

        private CharSumProcedure() {
        }

        public void value(char each) {
            this.sum = (char)(this.sum + each);
        }

        public char getValue() {
            return this.sum;
        }
    }

    private static final class CharMinProcedure
    implements CharProcedure {
        private boolean visitedOnce;
        private char min;

        private CharMinProcedure() {
        }

        public void value(char each) {
            if (this.visitedOnce) {
                if (each < this.min) {
                    this.min = each;
                }
            } else {
                this.min = each;
                this.visitedOnce = true;
            }
        }

        public char getValue() {
            return this.min;
        }
    }

    private static final class CharMaxProcedure
    implements CharProcedure {
        private boolean visitedOnce;
        private char max;

        private CharMaxProcedure() {
        }

        public void value(char each) {
            if (this.visitedOnce) {
                if (this.max < each) {
                    this.max = each;
                }
            } else {
                this.max = each;
                this.visitedOnce = true;
            }
        }

        public char getValue() {
            return this.max;
        }
    }
}

