/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToBooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteToCharFunction;
import com.gs.collections.api.block.function.primitive.ByteToDoubleFunction;
import com.gs.collections.api.block.function.primitive.ByteToFloatFunction;
import com.gs.collections.api.block.function.primitive.ByteToIntFunction;
import com.gs.collections.api.block.function.primitive.ByteToLongFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ByteToShortFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.block.factory.primitive.BytePredicates;
import com.gs.collections.impl.factory.primitive.ByteSets;
import com.gs.collections.impl.lazy.primitive.CollectByteToBooleanIterable;
import com.gs.collections.impl.lazy.primitive.CollectByteToByteIterable;
import com.gs.collections.impl.lazy.primitive.CollectByteToCharIterable;
import com.gs.collections.impl.lazy.primitive.CollectByteToDoubleIterable;
import com.gs.collections.impl.lazy.primitive.CollectByteToFloatIterable;
import com.gs.collections.impl.lazy.primitive.CollectByteToIntIterable;
import com.gs.collections.impl.lazy.primitive.CollectByteToLongIterable;
import com.gs.collections.impl.lazy.primitive.CollectByteToShortIterable;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.utility.internal.primitive.ByteIterableIterate;
import com.gs.collections.impl.utility.primitive.LazyByteIterate;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLazyByteIterable
implements LazyByteIterable {
    @Override
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public int size() {
        return this.count(BytePredicates.alwaysTrue());
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public boolean isEmpty() {
        return ByteIterableIterate.isEmpty(this);
    }

    @Override
    public boolean notEmpty() {
        return ByteIterableIterate.notEmpty(this);
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        ByteIterableIterate.appendString(this, appendable, start, separator, end);
    }

    @Override
    public boolean contains(byte value) {
        return this.anySatisfy(BytePredicates.equal(value));
    }

    @Override
    public boolean containsAll(byte ... source) {
        return this.containsAll(ByteSets.immutable.of(source));
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        return source.allSatisfy(new BytePredicate(){

            public boolean accept(byte value) {
                return AbstractLazyByteIterable.this.contains(value);
            }
        });
    }

    @Override
    public LazyByteIterable select(BytePredicate predicate) {
        return LazyByteIterate.select(this, predicate);
    }

    @Override
    public LazyByteIterable reject(BytePredicate predicate) {
        return LazyByteIterate.select(this, BytePredicates.not(predicate));
    }

    @Override
    public <V> LazyIterable<V> collect(ByteToObjectFunction<? extends V> function) {
        return LazyByteIterate.collect(this, function);
    }

    @Override
    public LazyBooleanIterable collectBoolean(ByteToBooleanFunction function) {
        return new CollectByteToBooleanIterable(this, function);
    }

    @Override
    public LazyByteIterable collectByte(ByteToByteFunction function) {
        return new CollectByteToByteIterable(this, function);
    }

    @Override
    public LazyCharIterable collectChar(ByteToCharFunction function) {
        return new CollectByteToCharIterable(this, function);
    }

    @Override
    public LazyShortIterable collectShort(ByteToShortFunction function) {
        return new CollectByteToShortIterable(this, function);
    }

    @Override
    public LazyIntIterable collectInt(ByteToIntFunction function) {
        return new CollectByteToIntIterable(this, function);
    }

    @Override
    public LazyFloatIterable collectFloat(ByteToFloatFunction function) {
        return new CollectByteToFloatIterable(this, function);
    }

    @Override
    public LazyLongIterable collectLong(ByteToLongFunction function) {
        return new CollectByteToLongIterable(this, function);
    }

    @Override
    public LazyDoubleIterable collectDouble(ByteToDoubleFunction function) {
        return new CollectByteToDoubleIterable(this, function);
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return ByteIterableIterate.detectIfNone(this, predicate, ifNone);
    }

    @Override
    public int count(BytePredicate predicate) {
        return ByteIterableIterate.count(this, predicate);
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return ByteIterableIterate.anySatisfy(this, predicate);
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return ByteIterableIterate.allSatisfy(this, predicate);
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        return ByteIterableIterate.noneSatisfy(this, predicate);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return ByteIterableIterate.injectInto(this, injectedValue, function);
    }

    @Override
    public byte[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public MutableByteList toList() {
        final ByteArrayList list = new ByteArrayList();
        this.forEach(new ByteProcedure(){

            public void value(byte each) {
                list.add(each);
            }
        });
        return list;
    }

    @Override
    public MutableByteSet toSet() {
        final ByteHashSet set = new ByteHashSet();
        this.forEach(new ByteProcedure(){

            public void value(byte each) {
                set.add(each);
            }
        });
        return set;
    }

    @Override
    public MutableByteBag toBag() {
        final ByteHashBag bag = new ByteHashBag();
        this.forEach(new ByteProcedure(){

            public void value(byte each) {
                bag.add(each);
            }
        });
        return bag;
    }

    @Override
    public long sum() {
        ByteSumProcedure procedure = new ByteSumProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    @Override
    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ByteMaxProcedure procedure = new ByteMaxProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    @Override
    public byte maxIfEmpty(byte ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.max();
    }

    @Override
    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ByteMinProcedure procedure = new ByteMinProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    @Override
    public byte minIfEmpty(byte ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.min();
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public byte[] toSortedArray() {
        return this.toSortedList().toArray();
    }

    @Override
    public MutableByteList toSortedList() {
        return ByteArrayList.newList(this).sortThis();
    }

    @Override
    public LazyByteIterable asLazy() {
        return this;
    }

    private static final class ByteSumProcedure
    implements ByteProcedure {
        private byte sum = 0;

        private ByteSumProcedure() {
        }

        public void value(byte each) {
            this.sum = (byte)(this.sum + each);
        }

        public byte getValue() {
            return this.sum;
        }
    }

    private static final class ByteMinProcedure
    implements ByteProcedure {
        private boolean visitedOnce;
        private byte min;

        private ByteMinProcedure() {
        }

        public void value(byte each) {
            if (this.visitedOnce) {
                if (each < this.min) {
                    this.min = each;
                }
            } else {
                this.min = each;
                this.visitedOnce = true;
            }
        }

        public byte getValue() {
            return this.min;
        }
    }

    private static final class ByteMaxProcedure
    implements ByteProcedure {
        private boolean visitedOnce;
        private byte max;

        private ByteMaxProcedure() {
        }

        public void value(byte each) {
            if (this.visitedOnce) {
                if (this.max < each) {
                    this.max = each;
                }
            } else {
                this.max = each;
                this.visitedOnce = true;
            }
        }

        public byte getValue() {
            return this.max;
        }
    }
}

