/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.set;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.ParallelIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.multimap.bag.UnsortedBagMultimap;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.lazy.parallel.AbstractParallelIterable;
import com.gs.collections.impl.lazy.parallel.AbstractParallelIterableImpl;
import com.gs.collections.impl.lazy.parallel.Batch;
import com.gs.collections.impl.lazy.parallel.set.ParallelFlatCollectIterable;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class ParallelCollectIterable<T, V>
extends AbstractParallelIterableImpl<V, Batch<V>> {
    private final AbstractParallelIterable<T, ? extends Batch<T>> delegate;
    private final Function<? super T, ? extends V> function;

    public ParallelCollectIterable(AbstractParallelIterable<T, ? extends Batch<T>> delegate, Function<? super T, ? extends V> function) {
        this.delegate = delegate;
        this.function = function;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.delegate.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.delegate.getBatchSize();
    }

    @Override
    public LazyIterable<Batch<V>> split() {
        return this.delegate.split().collect(new Function<Batch<T>, Batch<V>>(){

            @Override
            public Batch<V> valueOf(Batch<T> eachBatch) {
                return eachBatch.collect(ParallelCollectIterable.this.function);
            }
        });
    }

    @Override
    public void forEach(Procedure<? super V> procedure) {
        this.delegate.forEach(Functions.bind(procedure, this.function));
    }

    @Override
    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.delegate.anySatisfy(Predicates.attributePredicate(this.function, predicate));
    }

    @Override
    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.delegate.allSatisfy(Predicates.attributePredicate(this.function, predicate));
    }

    @Override
    public V detect(Predicate<? super V> predicate) {
        T resultItem = this.delegate.detect(Predicates.attributePredicate(this.function, predicate));
        return resultItem == null ? null : (V)this.function.valueOf((T)resultItem);
    }

    @Override
    public <V1> ParallelIterable<V1> flatCollect(Function<? super V, ? extends Iterable<V1>> function) {
        return new ParallelFlatCollectIterable(this, function);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toList().collect(this.function).toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.delegate.toList().collect(this.function).toArray(array);
    }

    @Override
    public <V1> UnsortedBagMultimap<V1, V> groupBy(Function<? super V, ? extends V1> function) {
        return this.delegate.toBag().collect(this.function).groupBy(function);
    }

    @Override
    public <V1> UnsortedBagMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function) {
        return this.delegate.toBag().collect(this.function).groupByEach(function);
    }

    @Override
    public <V1> MapIterable<V1, V> groupByUniqueKey(Function<? super V, ? extends V1> function) {
        return this.delegate.toBag().collect(this.function).groupByUniqueKey(function);
    }
}

