/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.list;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.impl.lazy.parallel.AbstractParallelIterable;
import com.gs.collections.impl.lazy.parallel.OrderedBatch;
import com.gs.collections.impl.lazy.parallel.list.AbstractParallelListIterable;
import com.gs.collections.impl.lazy.parallel.list.ListBatch;
import com.gs.collections.impl.utility.Iterate;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class ParallelFlatCollectListIterable<T, V>
extends AbstractParallelListIterable<V, ListBatch<V>> {
    private final AbstractParallelIterable<T, ? extends OrderedBatch<T>> parallelIterable;
    private final Function<? super T, ? extends Iterable<V>> function;

    public ParallelFlatCollectListIterable(AbstractParallelIterable<T, ? extends OrderedBatch<T>> parallelIterable, Function<? super T, ? extends Iterable<V>> function) {
        this.parallelIterable = parallelIterable;
        this.function = function;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.parallelIterable.getBatchSize();
    }

    @Override
    public LazyIterable<ListBatch<V>> split() {
        return this.parallelIterable.split().collect(new Function<OrderedBatch<T>, ListBatch<V>>(){

            @Override
            public ListBatch<V> valueOf(OrderedBatch<T> batch) {
                return batch.flatCollect(ParallelFlatCollectListIterable.this.function);
            }
        });
    }

    @Override
    public void forEach(final Procedure<? super V> procedure) {
        this.parallelIterable.forEach(new Procedure<T>(){

            @Override
            public void value(T each) {
                Iterate.forEach((Iterable)ParallelFlatCollectListIterable.this.function.valueOf(each), procedure);
            }
        });
    }

    @Override
    public V detect(final Predicate<? super V> predicate) {
        final AtomicReference result = new AtomicReference();
        this.parallelIterable.anySatisfy(new Predicate<T>(){

            @Override
            public boolean accept(T each) {
                return Iterate.anySatisfy((Iterable)ParallelFlatCollectListIterable.this.function.valueOf(each), new Predicate<V>(){

                    @Override
                    public boolean accept(V each) {
                        if (predicate.accept(each)) {
                            result.compareAndSet(null, each);
                            return true;
                        }
                        return false;
                    }
                });
            }
        });
        return result.get();
    }

    @Override
    public boolean anySatisfy(final Predicate<? super V> predicate) {
        return this.parallelIterable.anySatisfy(new Predicate<T>(){

            @Override
            public boolean accept(T each) {
                return Iterate.anySatisfy((Iterable)ParallelFlatCollectListIterable.this.function.valueOf(each), predicate);
            }
        });
    }

    @Override
    public boolean allSatisfy(final Predicate<? super V> predicate) {
        return this.parallelIterable.allSatisfy(new Predicate<T>(){

            @Override
            public boolean accept(T each) {
                return Iterate.allSatisfy((Iterable)ParallelFlatCollectListIterable.this.function.valueOf(each), predicate);
            }
        });
    }
}

