/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.list;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.list.ListIterable;
import com.gs.collections.api.list.ParallelListIterable;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.multimap.list.ListMultimap;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.parallel.AbstractParallelIterable;
import com.gs.collections.impl.lazy.parallel.list.AbstractParallelListIterable;
import com.gs.collections.impl.lazy.parallel.list.ListIterableBatch;
import com.gs.collections.impl.lazy.parallel.list.ParallelFlatCollectListIterable;
import com.gs.collections.impl.lazy.parallel.list.RootListBatch;
import java.util.Iterator;
import java.util.RandomAccess;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class ListIterableParallelIterable<T>
extends AbstractParallelListIterable<T, RootListBatch<T>> {
    private final ListIterable<T> delegate;
    private final ExecutorService executorService;
    private final int batchSize;

    public ListIterableParallelIterable(ListIterable<T> delegate, ExecutorService executorService, int batchSize) {
        if (executorService == null) {
            throw new NullPointerException();
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException();
        }
        if (!(delegate instanceof RandomAccess)) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
        this.executorService = executorService;
        this.batchSize = batchSize;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public LazyIterable<RootListBatch<T>> split() {
        return new ListIterableParallelBatchLazyIterable();
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        AbstractParallelIterable.forEach(this, procedure);
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return AbstractParallelIterable.anySatisfy(this, predicate);
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return AbstractParallelIterable.allSatisfy(this, predicate);
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return AbstractParallelIterable.detect(this, predicate);
    }

    @Override
    public <V> ParallelListIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return new ParallelFlatCollectListIterable(this, function);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.delegate.toArray(array);
    }

    @Override
    public <V> ListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.delegate.groupBy(function);
    }

    @Override
    public <V> ListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.delegate.groupByEach(function);
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.delegate.groupByUniqueKey(function);
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIterableParallelBatchLazyIterable
    extends AbstractLazyIterable<RootListBatch<T>> {
        private ListIterableParallelBatchLazyIterable() {
        }

        @Override
        public void each(Procedure<? super RootListBatch<T>> procedure) {
            for (RootListBatch chunk : this) {
                procedure.value(chunk);
            }
        }

        @Override
        public Iterator<RootListBatch<T>> iterator() {
            return new ListIterableParallelBatchIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIterableParallelBatchIterator
    implements Iterator<RootListBatch<T>> {
        protected int chunkIndex;

        private ListIterableParallelBatchIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.chunkIndex * ListIterableParallelIterable.this.getBatchSize() < ListIterableParallelIterable.this.delegate.size();
        }

        @Override
        public RootListBatch<T> next() {
            int chunkStartIndex = this.chunkIndex * ListIterableParallelIterable.this.getBatchSize();
            int chunkEndIndex = (this.chunkIndex + 1) * ListIterableParallelIterable.this.getBatchSize();
            int truncatedChunkEndIndex = Math.min(chunkEndIndex, ListIterableParallelIterable.this.delegate.size());
            ++this.chunkIndex;
            return new ListIterableBatch(ListIterableParallelIterable.this.delegate, chunkStartIndex, truncatedChunkEndIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot call remove() on " + ListIterableParallelIterable.this.delegate.getClass().getSimpleName());
        }
    }
}

