/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.bag;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.procedure.IfProcedure;
import com.gs.collections.impl.lazy.parallel.bag.AbstractParallelUnsortedBag;
import com.gs.collections.impl.lazy.parallel.bag.UnsortedBagBatch;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
class ParallelSelectUnsortedBag<T>
extends AbstractParallelUnsortedBag<T, UnsortedBagBatch<T>> {
    private final AbstractParallelUnsortedBag<T, ? extends UnsortedBagBatch<T>> parallelIterable;
    private final Predicate<? super T> predicate;

    ParallelSelectUnsortedBag(AbstractParallelUnsortedBag<T, ? extends UnsortedBagBatch<T>> parallelIterable, Predicate<? super T> predicate) {
        this.parallelIterable = parallelIterable;
        this.predicate = predicate;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.parallelIterable.getBatchSize();
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.parallelIterable.forEach(new IfProcedure<T>(this.predicate, procedure));
    }

    @Override
    public void forEachWithOccurrences(final ObjectIntProcedure<? super T> procedure) {
        this.parallelIterable.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            @Override
            public void value(T each, int parameter) {
                if (ParallelSelectUnsortedBag.this.predicate.accept(each)) {
                    procedure.value(each, parameter);
                }
            }
        });
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.parallelIterable.anySatisfy(Predicates.and(this.predicate, predicate));
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.parallelIterable.allSatisfy(new SelectAllSatisfyPredicate(this.predicate, predicate));
    }

    @Override
    public LazyIterable<UnsortedBagBatch<T>> split() {
        return this.parallelIterable.split().collect(new Function<UnsortedBagBatch<T>, UnsortedBagBatch<T>>(){

            @Override
            public UnsortedBagBatch<T> valueOf(UnsortedBagBatch<T> eachBatch) {
                return eachBatch.select(ParallelSelectUnsortedBag.this.predicate);
            }
        });
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return this.parallelIterable.detect(Predicates.and(this.predicate, predicate));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelectAllSatisfyPredicate<T>
    implements Predicate<T> {
        private final Predicate<? super T> left;
        private final Predicate<? super T> right;

        private SelectAllSatisfyPredicate(Predicate<? super T> left, Predicate<? super T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean accept(T each) {
            boolean leftResult = this.left.accept(each);
            return !leftResult || this.right.accept(each);
        }
    }
}

