/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.bag;

import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.ParallelUnsortedBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.multimap.bag.UnsortedBagMultimap;
import com.gs.collections.api.set.ParallelUnsortedSetIterable;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.procedure.BagAddOccurrencesProcedure;
import com.gs.collections.impl.lazy.parallel.AbstractParallelIterable;
import com.gs.collections.impl.lazy.parallel.bag.ParallelCollectUnsortedBag;
import com.gs.collections.impl.lazy.parallel.bag.ParallelSelectUnsortedBag;
import com.gs.collections.impl.lazy.parallel.bag.UnsortedBagBatch;
import com.gs.collections.impl.multimap.bag.SynchronizedPutHashBagMultimap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractParallelUnsortedBag<T, B extends UnsortedBagBatch<T>>
extends AbstractParallelIterable<T, B>
implements ParallelUnsortedBag<T> {
    @Override
    protected boolean isOrdered() {
        return false;
    }

    @Override
    public ParallelUnsortedSetIterable<T> asUnique() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asUnique() not implemented yet");
    }

    @Override
    public ParallelUnsortedBag<T> select(Predicate<? super T> predicate) {
        return new ParallelSelectUnsortedBag<T>(this, predicate);
    }

    @Override
    public <P> ParallelUnsortedBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <S> ParallelUnsortedBag<S> selectInstancesOf(Class<S> clazz) {
        return this.select(Predicates.instanceOf(clazz));
    }

    @Override
    public ParallelUnsortedBag<T> reject(Predicate<? super T> predicate) {
        return this.select(Predicates.not(predicate));
    }

    @Override
    public <P> ParallelUnsortedBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <V> ParallelUnsortedBag<V> collect(Function<? super T, ? extends V> function) {
        return new ParallelCollectUnsortedBag<T, V>(this, function);
    }

    @Override
    public <P, V> ParallelUnsortedBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect((Function)Functions.bind(function, parameter));
    }

    @Override
    public <V> ParallelUnsortedBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.select((Predicate)predicate).collect(function);
    }

    @Override
    public <V> ParallelUnsortedBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".flatCollect() not implemented yet");
    }

    @Override
    public MutableBag<T> toBag() {
        MutableCollection result = HashBag.newBag().asSynchronized();
        this.forEachWithOccurrences(BagAddOccurrencesProcedure.on(result));
        return result;
    }

    @Override
    public <V> UnsortedBagMultimap<V, T> groupBy(final Function<? super T, ? extends V> function) {
        final SynchronizedPutHashBagMultimap result = SynchronizedPutHashBagMultimap.newMultimap();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            @Override
            public void value(T each, int occurrences) {
                Object key = function.valueOf(each);
                for (int i = 0; i < occurrences; ++i) {
                    result.put(key, each);
                }
            }
        });
        return result;
    }

    @Override
    public <V> UnsortedBagMultimap<V, T> groupByEach(final Function<? super T, ? extends Iterable<V>> function) {
        final SynchronizedPutHashBagMultimap result = SynchronizedPutHashBagMultimap.newMultimap();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            @Override
            public void value(T each, int occurrences) {
                Iterable keys = (Iterable)function.valueOf(each);
                for (Object key : keys) {
                    for (int i = 0; i < occurrences; ++i) {
                        result.put(key, each);
                    }
                }
            }
        });
        return result;
    }
}

