/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.iterator;

import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.impl.factory.Lists;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class ChunkIterator<T>
implements Iterator<RichIterable<T>> {
    private final Iterator<T> iterator;
    private final int size;
    private final Function0<MutableCollection<T>> speciesNewStrategy;

    public ChunkIterator(final Iterable<T> iterable, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        this.size = size;
        this.iterator = iterable.iterator();
        this.speciesNewStrategy = iterable instanceof MutableCollection ? new Function0<MutableCollection<T>>(){

            @Override
            public MutableCollection<T> value() {
                return ((MutableCollection)iterable).newEmpty();
            }
        } : new Function0<MutableCollection<T>>(){

            @Override
            public MutableCollection<T> value() {
                return Lists.mutable.empty();
            }
        };
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public RichIterable<T> next() {
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        MutableCollection<T> result = this.speciesNewStrategy.value();
        for (int i = this.size; i > 0 && this.iterator.hasNext(); --i) {
            result.add(this.iterator.next());
        }
        return result;
    }
}

