/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.iterator.TakeIterator;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class TakeIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;
    private final int count;

    public TakeIterable(Iterable<T> newAdapted, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        this.adapted = newAdapted;
        this.count = count;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        Iterator<T> iterator = this.adapted.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            procedure.value(iterator.next());
        }
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> procedure) {
        Iterator<T> iterator = this.adapted.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            procedure.value(iterator.next(), i);
        }
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterator<T> iterator = this.adapted.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            procedure.value(iterator.next(), parameter);
        }
    }

    @Override
    public Object[] toArray() {
        final Object[] result = new Object[this.count];
        this.forEachWithIndex(new ObjectIntProcedure<T>(){

            @Override
            public void value(T each, int index) {
                result[index] = each;
            }
        });
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new TakeIterator<T>(this.adapted, this.count);
    }
}

