/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy;

import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.procedure.IfObjectIntProcedure;
import com.gs.collections.impl.block.procedure.IfProcedure;
import com.gs.collections.impl.block.procedure.IfProcedureWith;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.AllSatisfyPredicate;
import com.gs.collections.impl.lazy.iterator.SelectInstancesOfIterator;
import com.gs.collections.impl.utility.Iterate;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SelectInstancesOfIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<?> adapted;
    private final Class<T> clazz;

    public SelectInstancesOfIterable(Iterable<?> newAdapted, Class<T> clazz) {
        this.adapted = newAdapted;
        this.clazz = clazz;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        Iterate.forEach(this.adapted, new IfProcedure<T>(Predicates.instanceOf(this.clazz), procedure));
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        Iterate.forEach(this.adapted, new IfObjectIntProcedure<T>(Predicates.instanceOf(this.clazz), objectIntProcedure));
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.adapted, new IfProcedureWith<T, P>(Predicates.instanceOf(this.clazz), procedure), parameter);
    }

    @Override
    public T getFirst() {
        return this.clazz.cast(Iterate.detect(this.adapted, Predicates.instanceOf(this.clazz)));
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return Iterate.anySatisfy(this.adapted, Predicates.and(Predicates.instanceOf(this.clazz), predicate));
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.anySatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return Iterate.allSatisfy(this.adapted, new AllSatisfyPredicate<T>(Predicates.instanceOf(this.clazz), predicate));
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.allSatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return Iterate.noneSatisfy(this.adapted, new AllSatisfyPredicate<T>(Predicates.instanceOf(this.clazz), predicate));
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.noneSatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return Iterate.detect(this.adapted, Predicates.and(Predicates.instanceOf(this.clazz), predicate));
    }

    @Override
    public Iterator<T> iterator() {
        return new SelectInstancesOfIterator<T>(this.adapted, this.clazz);
    }
}

